package view;

import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;

import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

import controller.Controller;

public class MapMenu extends JMenuBar {
	public MapMenu(Controller control) {
		JMenu menu0 = new JMenu("ファイル(F)");
		menu0.setMnemonic(KeyEvent.VK_F);

		JMenu menu1 = new JMenu("探索設定(S)");
		menu1.setMnemonic(KeyEvent.VK_S);

		JMenu menu2 = new JMenu("表示設定(V)");
		menu2.setMnemonic(KeyEvent.VK_V);
		
		JMenu menu3 = new JMenu("移動(M)");
		menu3.setMnemonic(KeyEvent.VK_M);

		JMenu menu4 = new JMenu("ヘルプ(H)");
		menu4.setMnemonic(KeyEvent.VK_H);

		JMenuItem item0_1 = new JMenuItem("印刷");
		item0_1.setActionCommand("print");
		item0_1.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_P, InputEvent.CTRL_DOWN_MASK));

		JMenuItem item0_2 = new JMenuItem("エクスポート(PNG)");
		item0_2.setActionCommand("exportPNG");
		item0_2.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_S, InputEvent.CTRL_DOWN_MASK));
		
		JMenuItem item0_5 = new JMenuItem("終了");
		item0_5.setActionCommand("exit");
		item0_5.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_X, InputEvent.CTRL_DOWN_MASK));

		menu0.add(item0_1);
		menu0.add(item0_2);

		menu0.addSeparator();
		menu0.add(item0_5);

		JCheckBoxMenuItem item1_1 = new JCheckBoxMenuItem("Dijkstra", false);
		item1_1.setActionCommand("path_dijkstra");
		JCheckBoxMenuItem item1_2 = new JCheckBoxMenuItem("A*", true);
		item1_2.setActionCommand("path_a*");
		JCheckBoxMenuItem item1_3 = new JCheckBoxMenuItem("高速道路", true);
		item1_3.setActionCommand("highway");

		ButtonGroup group = new ButtonGroup();
		group.add(item1_1);
		group.add(item1_2);

		menu1.add(item1_1);
		menu1.add(item1_2);
		menu1.addSeparator();
		menu1.add(item1_3);

		JMenu item2_1 = new JMenu("ラベル表示");

		JCheckBoxMenuItem item2_1_1 = new JCheckBoxMenuItem("駅", true);
		item2_1_1.setActionCommand("labelStation");
		JCheckBoxMenuItem item2_1_2 = new JCheckBoxMenuItem("地名", true);
		item2_1_2.setActionCommand("labelCity");
		JCheckBoxMenuItem item2_1_3 = new JCheckBoxMenuItem("施設", true);
		item2_1_3.setActionCommand("labelFacility");

		item2_1.add(item2_1_1);
		item2_1.add(item2_1_2);
		item2_1.add(item2_1_3);

		JCheckBoxMenuItem item2_2 = new JCheckBoxMenuItem("頂点表示", false);
		item2_2.setActionCommand("node");
		JCheckBoxMenuItem item2_3 = new JCheckBoxMenuItem("アンチエイリアス", true);
		item2_3.setActionCommand("alias");

		menu2.add(item2_1);
		menu2.add(item2_2);
		menu2.add(item2_3);

		item0_1.addActionListener(control);
		item0_2.addActionListener(control);
		item0_5.addActionListener(control);

		item1_1.addActionListener(control);
		item1_2.addActionListener(control);
		item1_3.addActionListener(control);

		item2_1_1.addActionListener(control);
		item2_1_2.addActionListener(control);
		item2_1_3.addActionListener(control);

		item2_2.addActionListener(control);
		item2_3.addActionListener(control);

		JMenuItem menu3_1 = new JMenuItem("日本全域を表示倍率");
		menu3_1.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_HOME, InputEvent.CTRL_DOWN_MASK));
		menu3_1.setActionCommand("move_home");
		menu3_1.addActionListener(control);
		menu3.add(menu3_1);

		JMenuItem menu3_2 = new JMenuItem("数値地図を表示倍率");
		menu3_2.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_COLON, InputEvent.CTRL_DOWN_MASK));
		menu3_2.setActionCommand("move_sdf");
		menu3_2.addActionListener(control);
		menu3.add(menu3_2);

		menu3.addSeparator();
		
		JMenuItem menu3_3 = new JMenuItem("緯度経度を指定して移動");
		menu3_3.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_M, InputEvent.CTRL_DOWN_MASK));
		menu3_3.setActionCommand("move_location");
		menu3_3.addActionListener(control);
		menu3.add(menu3_3);
		
		JMenuItem help4_1 = new JMenuItem("操作マニュアルを開く");
		help4_1.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_H, InputEvent.CTRL_DOWN_MASK));
		help4_1.setActionCommand("manual");
		help4_1.addActionListener(control);
		menu4.add(help4_1);
		
		JMenuItem help4_2 = new JCheckBoxMenuItem("基本操作マニュアル", control.getSetting().isManual());
		help4_2.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_F1, InputEvent.CTRL_DOWN_MASK));
		help4_2.setActionCommand("help");
		help4_2.addActionListener(control);
		menu4.add(help4_2);

		menu4.addSeparator();

		JMenuItem help4_3 = new JMenuItem("ソフトウェアの更新を確認(O)");
		help4_3.setMnemonic(KeyEvent.VK_O);
		help4_3.setActionCommand("version");
		help4_3.addActionListener(control);
		menu4.add(help4_3);

		final JCheckBoxMenuItem help4_4 = new JCheckBoxMenuItem("起動時に更新を確認する", control.getSetting().isCheckUpdate());
		help4_4.setActionCommand("check");
		help4_4.addActionListener(control);
		menu4.add(help4_4);

		menu4.addSeparator();
		
		final JMenuItem help4_5 = new JMenuItem("Digital Mapについて");
		help4_5.setActionCommand("about");
		help4_5.addActionListener(control);
		menu4.add(help4_5);
		
		control.setUpdateCheck(help4_4);

		this.add(menu0);
		this.add(menu1);
		this.add(menu2);
		this.add(menu3);
		this.add(menu4);
	}
}
