import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import util.Log;

import map.model.City;
import map.store.ChainStore;

/**
 * 業務スーパーの店舗情報を取得するクラス
 * @author Masyasu Fujiwara
 *
 */
public class GyomuSuperPlugin extends ChainStore {
	private Pattern addressParser;

	public GyomuSuperPlugin() {
		super("業務スーパー");
	}

	@Override
	protected URL getURL(City city, int page) {
		int prefCode = city.getCode() / 1000;
		URL url = null;
		if (page == 1) {
			try {
				if (prefCode <= 7) {
					url = new URL("http://www.kobebussan.co.jp/kb_gs_tenpo_tohoku.htm");
				} else if (prefCode <= 14) {
					url = new URL("http://www.kobebussan.co.jp/kb_gs_tenpo_kanto.htm");
				} else if (prefCode <= 24) {
					url = new URL("http://www.kobebussan.co.jp/kb_gs_tenpo_tyubu.htm");
				} else if (prefCode <= 30) {
					url = new URL("http://www.kobebussan.co.jp/kb_gs_tenpo_kansai.htm");
				} else if (prefCode <= 35) {
					url = new URL("http://www.kobebussan.co.jp/kb_gs_tenpo_tyugoku.htm");
				} else if (prefCode <= 39) {
					url = new URL("http://www.kobebussan.co.jp/kb_gs_tenpo_sikoku.htm");
				} else {
					url = new URL("http://www.kobebussan.co.jp/kb_gs_tenpo_kyusyu.htm");
				}
				this.addressParser = Pattern.compile("([^<>]*" + city.getName() + "[^<>]+)");
			} catch (MalformedURLException e) {
				Log.err(this, e);
			}
		}
		return url;
	}

	@Override
	protected String parseAddress(String input) {
		Matcher matcher = this.addressParser.matcher(input);
		if (matcher.find()) {
			return matcher.group(1);
		}
		return null;
	}
	
}
