import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import map.AddressMatching;
import map.model.City;
import map.store.ChainStore;


public class Test {
	public static void main(String[] args) throws IOException {
		ChainStore store = new CircleKPlugin();
		AddressMatching matching = AddressMatching.getInstance();
		List<City> cities = new ArrayList<City>();
		cities.add(new City(1101, "札幌市中央区", null));
		cities.add(new City(28102, "神戸市灘区", null));
		cities.add(new City(28204, "西宮市", null));
		cities.add(new City(28213, "西脇市", null));
		for (City city : cities) {
			System.out.println(city);
			for (String arg : store.getAddress(city)) {
				System.out.println("base  : " + arg);
				arg = matching.format(arg);
				System.out.println("format: " + arg);
				for (String ret : matching.parseAddress(arg)) {
					System.out.println("\t" + ret);
				}
				System.out.println();
			}
			System.out.println();
		}
	}
}
