/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.gcat.scalc;

import jp.jasminesoft.gcat.scalc.MeshCodeManager;
import jp.jasminesoft.gcat.scalc.Radians;
import jp.jasminesoft.gcat.scalc.Rate;
import jp.jasminesoft.gcat.scalc.XY;

public class LatLong2XY {
    private MeshCodeManager meshman = MeshCodeManager.getInstance();
    private double lat;
    private double lng;
    private int kei;
    private double r_lat;
    private double r_lng;
    private double x;
    private double y;
    private boolean needsCalcFlag;

    public LatLong2XY() {
        this(-1);
    }

    public LatLong2XY(int kei) {
        this.setNeedsCalcFlag(true);
        this.kei = kei;
    }

    public void setLatitude(double lat) {
        this.lat = lat * 10000.0;
        this.setNeedsCalcFlag(true);
    }

    public void setLongitude(double lng) {
        this.lng = lng * 10000.0;
        this.setNeedsCalcFlag(true);
    }

    public void setKei(int kei) {
        this.kei = kei;
        this.setNeedsCalcFlag(true);
    }

    public double getLatitude() {
        return this.lat;
    }

    public double getLongitude() {
        return this.lng;
    }

    public int getKei() {
        return this.kei;
    }

    public double getX() {
        if (this.needsCalcFlag) {
            this.calc();
        }
        return this.x;
    }

    public double getY() {
        if (this.needsCalcFlag) {
            this.calc();
        }
        return this.y;
    }

    private synchronized void setNeedsCalcFlag(boolean b) {
        this.needsCalcFlag = b;
    }

    private void calc() {
        Radians rcnv_lat = new Radians(this.lat);
        Radians rcnv_lng = new Radians(this.lng);
        this.r_lat = rcnv_lat.getRadian();
        this.r_lng = rcnv_lng.getRadian();
        if (this.kei == -1) {
            this.kei = this.meshman.getProperKei(this.lat / 10000.0, this.lng / 10000.0);
        }
        if (this.kei > 0) {
            XY conv = new XY(this.r_lat, this.r_lng, this.kei);
            this.x = conv.getX();
            this.y = conv.getY();
        } else {
            this.x = Double.MIN_VALUE;
            this.y = Double.MIN_VALUE;
        }
        this.setNeedsCalcFlag(false);
    }

    public boolean isInvalid() {
        if (this.needsCalcFlag) {
            this.calc();
        }
        Rate rate = new Rate(this.r_lat, this.r_lng, this.x);
        return rate.hanteiM();
    }

    public static void main(String[] argv) {
        double lng = 131.0;
        double lat = 33.0;
        int kei = 2;
        if (argv.length >= 3) {
            lng = Double.parseDouble(argv[0]);
            lat = Double.parseDouble(argv[1]);
            kei = Integer.parseInt(argv[2]);
        }
        System.out.println("Lat:" + lat + ", Lng:" + lng + ", kei:" + kei);
        LatLong2XY prg = new LatLong2XY(kei);
        prg.setLongitude(lng);
        prg.setLatitude(lat);
        System.out.println("X:" + prg.getX() + ",Y:" + prg.getY() + " [" + prg.isInvalid() + "]");
    }
}

