import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import util.Log;

import map.model.City;
import map.store.ChainStore;

/**
 * ジャパン（親父）の店舗情報を取得します。
 * 
 * @author Masayasu Fujiwara
 */
public class JapanPlugin extends ChainStore {

	/**
	 * 店舗切り出しパターン
	 */
	private Pattern addressParser;
	
	/**
	 * 店舗位置確認パターン
	 */
	private Pattern SHOP_CHECKER;
	
	public JapanPlugin() {
		super("ジャパン");
		this.SHOP_CHECKER = Pattern.compile("店舗一覧");
	}
	
	@Override
	protected URL getURL(City city, int page) {
		URL url = null;
		if (page == 1) {
			try {
				url = new URL("http://www.japan-ds.com/Interest/Inter08.html");
				this.addressParser = Pattern.compile("<TD align=\"left\">([^<>]*" + city.getName() +"[^<>]*)</TD>");
				this.flag = false;
			} catch (MalformedURLException e) {
				Log.err(this, e);
			}
		}
		return url;
	}
	
	private boolean flag;
	@Override
	protected String parseAddress(String input) {
		if (!this.flag) {
			Matcher matcher = this.SHOP_CHECKER.matcher(input);
			if (matcher.find()) {
				this.flag = true;
			}
		} else {
			Matcher matcher = this.addressParser.matcher(input);
			if (matcher.find()) {
				return matcher.group(1);
			}
		}
		return null;
	}
}
