package labeling;

import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import map.model.City;
import map.model.Station;


/**
 * Wagnerらのラベル配置手法
 * @author ma38su
 *
 */
public class Wagner implements Labeling {
	private float scale;
	private Rectangle screen0;
	private Rectangle screen;
	private FontMetrics metrics;
	private int labelHeight;
	private List<Site> sites;
	private Graphics2D g;

	public Wagner(final Graphics2D g, final Rectangle screen, final int width, final int height, final float scale) {
		this.scale = scale;
		this.g = g;
		this.screen0 = screen;
		this.screen = new Rectangle(0, 0, width, height);
		this.metrics = g.getFontMetrics();
		this.labelHeight = this.metrics.getHeight();
		this.sites = new ArrayList<Site>();
	}

	public void add(Label[] data) {
		for (final Label point : data) {
			// 表示領域内のサイトに対してラベル候補を作成する。
			if (this.screen0.contains(point.getX(), point.getY())) {
				int siteX = (int) ((point.getX() - this.screen0.x) * this.scale);
				int siteY = this.screen.height - (int) ((point.getY() - this.screen0.y) * this.scale);
				String name = point.getName();
				Site site = new Site(name, siteX, siteY);
				int labelWidth = this.metrics.stringWidth(name);
				site.add(this.extractSite(siteX, siteY, labelWidth, this.labelHeight));
				this.sites.add(site);
			}
		}
	}
	public void add(Labels labels) {
		
	}
	private List<LabelCandidate> extractSite (final int x, final int y, final int width, final int height) {
		List<LabelCandidate> candidate = new LinkedList<LabelCandidate>();
		for (int i = 0; i < 4; i++) {
			LabelCandidate c = new LabelCandidate(x - width * (i % 2), y - height * (i / 2), width, height);
			if(this.screen.contains(c)) {
				candidate.add(c);
			}
		}
		int w = width / 2;
		int h = height / 2;
		candidate.add(new LabelCandidate(x,         y - h,      width, height));
		candidate.add(new LabelCandidate(x - width, y - h,      width, height));
		candidate.add(new LabelCandidate(x - w,     y,          width, height));
		candidate.add(new LabelCandidate(x - w,     y - height, width, height));
		return candidate;
	}
	private boolean flag = true;
	public void draw() {
		if(this.flag) {
			this.checkConflictSite();
			this.createConflictGraph();
			for(Site site : this.sites) {
				if(!site.isFixed()) {
					site.rule1();
				}
			}
			this.rule2();
			this.flag = false;
		}
		for (Site site : this.sites) {
			if(site.isFixed()) {
				this.g.draw(site.getLabel());
			} else {
				for (LabelCandidate label : site.getCandidates()) {
					this.g.draw(label);
				}
			}
			this.g.fillOval(site.getX() - 3, site.getY() - 3, 6, 6);
		}
	}
	/**
	 * ルール2
	 *
	 */
	private void rule2() {
		for (int i = 0; i < this.sites.size(); i++) {
			Site site0 = this.sites.get(i);
			if (!site0.isFixed()) {
				for (LabelCandidate candidate : site0.getCandidates()) {
					if(candidate.conflictOrder() == 1) {
//						candidate.checkRule2(site0);
					}
				}
			}
		}
	}
	/**
	 * コンフリクトグラフを作る
	 *
	 */
	private void createConflictGraph() {
		for (int i = 0; i < this.sites.size(); i++) {
			Site site0 = this.sites.get(i);
			for (int j = 0; j < this.sites.size(); j++) {
				if (i == j) {
					continue;
				}
				Site site = this.sites.get(j);
				
				for (LabelCandidate c0 : site0.getCandidates()) {
					for (LabelCandidate c : site.getCandidates()) {
						if(c0.intersects(c)) {
							c0.conflict(site0, c, site);
						}
					}
				}
			}
		}
	}
	/**
	 * サイトと重なるラベル候補を削除する
	 *
	 */
	private void checkConflictSite () {
		for (int i = 0; i < this.sites.size(); i++) {
			Site site0 = this.sites.get(i);
			for (int j = 0; j < this.sites.size(); j++) {
				if(i == j) {
					continue;
				}
				Site site = this.sites.get(j);
				Iterator<LabelCandidate> itr = site0.getCandidateIterator();
				while(itr.hasNext()) {
					LabelCandidate candidate = itr.next();
					if(candidate.contains(site.getX(), site.getY())) {
						itr.remove();
					}
				}
			}
		}
	}
	public void add(String name, int x, int y) {
		// TODO 自動生成されたメソッド・スタブ
		
	}
	public void drawRich() {
		// TODO 自動生成されたメソッド・スタブ
		
	}

	public void init(Graphics2D g, float scale, int width, int height) {
		// TODO 自動生成されたメソッド・スタブ
		
	}

	public void add(City city, int x, int y) {
		// TODO 自動生成されたメソッド・スタブ
		
	}

	public void set(String city, int x, int y) {
		// TODO 自動生成されたメソッド・スタブ
		
	}

	public void add(Station[] labels) {
		// TODO 自動生成されたメソッド・スタブ
		
	}

	public void switchShadow() {
		// TODO 自動生成されたメソッド・スタブ
		
	}

	public void setAntialias(boolean flag) {
		// TODO 自動生成されたメソッド・スタブ
		
	}

	public void switchAntialias() {
		// TODO 自動生成されたメソッド・スタブ
		
	}

	public void draw(int rendering) {
		// TODO 自動生成されたメソッド・スタブ
		
	}
}
