package map.route;

import java.util.Collection;

import map.model.Road;

/**
 * 探索のためのスレッド
 * 
 * @author ma38su
 *
 */
public interface SearchThread {

	/**
	 * このスレッドを殺します
	 *
	 */
	public void kill();

	/**
	 * 求めた最短経路の取得
	 * @return 最短経路のCollection
	 */
	public Collection<Road> getRoute();

	/**
	 * 訪問済み頂点数の取得
	 * @return 訪問済み頂点数の取得
	 */
	public int getVP();
}
