package util;

import java.awt.Polygon;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * ポリゴンを連結するクラス
 * @author Masayasu Fujiwara
 */
public class PolygonUtil {

	public static void main(String[] args) {
		int x1[] = new int[]{-10, -10, 0, 0};
		int y1[] = new int[]{0, 10, 10, 0};
		Polygon p1 = new Polygon(x1, y1, 4);
		int x2[] = new int[]{20, 20, 0, 0};
		int y2[] = new int[]{0, 10, 10, 0};
		Polygon p2 = new Polygon(x2, y2, 4);
		Polygon p3 = PolygonUtil.join(p1, p2);
		System.out.println("x: "+ Arrays.toString(p3.xpoints));
		System.out.println("y: "+ Arrays.toString(p3.ypoints));
	}

	/**
	 * ポリゴンを結合します。
	 * @param p1 結合するポリゴン
	 * @param i1 p1の結合するインデックス
	 * @param p2 結合するポリゴン
	 * @param i2 p2の結合するインデックス
	 * @param flag p2が順方向に結合する場合はtrue、逆方向に結合する場合はfalse
	 * @return 結合したポリゴン
	 */
	private static Polygon join(Polygon p1, int i1, Polygon p2, int i2, boolean flag) {
		int[] x = new int[p1.npoints + p2.npoints - 2];
		int[] y = new int[p1.npoints + p2.npoints - 2];
		int index = 0;
		int start = 0;
		if (i1 == p1.npoints - 1) {
			start = 1;
		}
		for (int i = start; i < i1; i++) {
			x[index] = p1.xpoints[i];
			y[index] = p1.ypoints[i];
			index++;
		}
		if (flag) {
			for (int i = i2; i >= 0; i--) {
				x[index] = p2.xpoints[i];
				y[index] = p2.ypoints[i];
				index++;
			}
			for (int i = p2.npoints - 1; i > i2; i--) {
				x[index] = p2.xpoints[i];
				y[index] = p2.ypoints[i];
				index++;
			}
		} else {
			for (int i = i2; i < p2.npoints; i++) {
				x[index] = p2.xpoints[i];
				y[index] = p2.ypoints[i];
				index++;
			}
			for (int i = 0; i < i2; i++) {
				x[index] = p2.xpoints[i];
				y[index] = p2.ypoints[i];
				index++;
			}
		}
		for (int i = i1 + 2; i < p1.npoints; i++) {
			x[index] = p1.xpoints[i];
			y[index] = p1.ypoints[i];
			index++;
		}
		return new Polygon(x, y, index);
	}
	
	/**
	 * ポリゴンを結合します。
	 * @param p1 結合するポリゴン
	 * @param p2 結合するポリゴン
	 * @return 結合できれば結合したポリゴンを返し、結合できなければnullを返します。
	 */
	public static Polygon join(Polygon p1, Polygon p2) {
		for (int i = 0; i < p1.npoints - 1; i++) {
			int ix = p1.xpoints[i];
			int iy = p1.ypoints[i];
			for (int j = 0; j < p2.npoints; j++) {
				int jx = p2.xpoints[j];
				int jy = p2.ypoints[j];
				if (ix == jx && iy == jy) {
					int ix1 = p1.xpoints[i + 1];
					int iy1 = p1.ypoints[i + 1];
					int ix2 = p1.xpoints[p1.npoints - 1];
					int iy2 = p1.ypoints[p1.npoints - 1];
					if (j + 1 < p2.npoints) {
						if (ix1 == p2.xpoints[j + 1] && iy1 == p2.ypoints[j + 1]) {
//							System.out.println("label7");
							return PolygonUtil.join(p1, i, p2, j, true);
						} else if (i == 0 && ix2 == p2.xpoints[j + 1] && iy2 == p2.ypoints[j + 1]) {
//							System.out.println("label8");
							return PolygonUtil.join(p1, p1.npoints - 1, p2, j + 1, false);
						}
					}
					if (j == 0) {
						if (ix1 == p2.xpoints[p2.npoints - 1] && iy1 == p2.ypoints[p2.npoints - 1]) {
//							System.out.println("label1");
							return PolygonUtil.join(p1, i, p2, j, false);
						} else if (i == 0 && ix2 == p2.xpoints[p2.npoints - 1] && iy2 == p2.ypoints[p2.npoints - 1]) {
//							System.out.println("label2");
							return PolygonUtil.join(p1, p1.npoints - 1, p2, p2.npoints - 1, true);
						}
					} else if (j == p2.npoints - 1) {
						if (ix1 == p2.xpoints[0] && iy1 == p2.ypoints[0]) {
//							System.out.println("label3");
							return PolygonUtil.join(p1, i, p2, j, true);
						} else if (i == 0 && ix2 == p2.xpoints[0] && iy2 == p2.ypoints[0]) {
//							System.out.println("label4");
							return PolygonUtil.join(p1, i, p2, j, true);
						}
					}
					if (j >= 1) {
						if (ix1 == p2.xpoints[j - 1] && iy1 == p2.ypoints[j - 1]) {
//							System.out.println("label5");
							return PolygonUtil.join(p1, i, p2, j, false);
						} else if (i == 0 && ix2 == p2.xpoints[j - 1] && iy2 == p2.ypoints[j - 1]) {
//							System.out.println("label6");
							return PolygonUtil.join(p1, i, p2, j, false);							
						}
					}
					Log.err(PolygonUtil.class, "join error");
					System.out.println("p1 x: + "+ Arrays.toString(p1.xpoints));
					System.out.println("p1 y: + "+ Arrays.toString(p1.ypoints));
					System.out.println("p2 x: + "+ Arrays.toString(p2.xpoints));
					System.out.println("p2 y: + "+ Arrays.toString(p2.ypoints));
					System.out.println("i: "+ i + ", "+ p1.npoints);
					System.out.println("j: "+ j + ", "+ p2.npoints);
				}
			}
		}
		return null;
	}
	
	/**
	 * ポリゴンを連結できれば連結します。
	 * @param polygon 
	 * @return 連結したポリゴン
	 */
	public static Polygon[] join(Polygon[] polygon) {
		List<Polygon> list = new ArrayList<Polygon>();
		Set<Integer> set = new HashSet<Integer>();
		for (int i = 0; i < polygon.length - 1; i++) {
			Log.out(PolygonUtil.class, "join: "+ i + " / "+ polygon.length);
			if (set.contains(i)) {
				continue;
			}
			for (int j = i + 1; j < polygon.length; j++) {
				if (set.contains(j)) {
					continue;
				}
				if (polygon[i].intersects(polygon[j].getBounds()) && polygon[j].intersects(polygon[i].getBounds())) {
					Polygon p = PolygonUtil.join(polygon[i], polygon[j]);
					if (p != null) {
						Log.out(PolygonUtil.class, "join("+ i + ", "+ j+ ")");
						set.add(j);
						polygon[i] = PolygonUtil.optimaize(p);
						j = i + 1;
					}
				}
			}
			list.add(polygon[i]);
		}
		return list.toArray(new Polygon[]{});
	}

	/**
	 * ポリゴンを最適化します。
	 * @param p ポリゴン
	 * @return 最適化したポリゴン
	 */
	public static Polygon optimaize(Polygon p) {
		for (int i = 0; i < p.npoints; i++) {
			if (i > 0 && i < p.npoints - 1) {
				if (p.xpoints[i - 1] == p.xpoints[i + 1] && p.ypoints[i - 1] == p.ypoints[i + 1]) {
					int[] x = new int[p.npoints - 1];
					int[] y = new int[p.npoints - 1];
					for (int j = 0; j < i; j++) {
						x[j] = p.xpoints[j];
						y[j] = p.ypoints[j];
					}
					for (int j = i + 1; j < p.npoints; j++) {
						x[j - 1] = p.xpoints[j];
						y[j - 1] = p.ypoints[j];
					}
					return PolygonUtil.optimaize(new Polygon(x, y, x.length));
				}
			} else if (i == 0) {
				if (p.xpoints[1] == p.xpoints[p.npoints - 1] && p.ypoints[1] == p.ypoints[p.npoints - 1]) {
					int[] x = new int[p.npoints - 1];
					int[] y = new int[p.npoints - 1];
					for (int j = 1; j < p.npoints; j++) {
						x[j - 1] = p.xpoints[j];
						y[j - 1] = p.ypoints[j];
					}
					return PolygonUtil.optimaize(new Polygon(x, y, x.length));
				}
			}
		}
		return p;
	}
}