import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.UIManager;

import tsp.Controller;
import tsp.Node;
import tsp.TspPanel;
import tsp.method.Greedy;
import tsp.method.Opt2;
import tsp.method.TspImprovement;
import tsp.method.TspTourConstruction;

/**
 * 起動のためのクラスです。
 * @author ma38su
 */
public class Main {
	public static void main(String[] args) {
		try {
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
		} catch (Exception e) {
			e.printStackTrace();
		}
		final TspTourConstruction tspConstruct = new Greedy();
		final TspImprovement tspImprovement = new Opt2();
		JFrame frame = new JFrame(tspConstruct.toString() + " + "+ tspImprovement);
		frame.setLayout(new BorderLayout());
		final TspPanel panel = new TspPanel();
		Controller controller = new Controller(panel);
		panel.addMouseListener(controller);
		frame.add(panel, BorderLayout.CENTER);
		JPanel subPanel = new JPanel();
		JButton startButton = new JButton("計算開始");
		subPanel.add(startButton);
		startButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				panel.clearRoute();
				List<Node> route = tspConstruct.method(panel.getNodes());
				route = tspImprovement.method(route);
				panel.add(route);
			}
		});
		JButton clearButton = new JButton("やり直し");
		subPanel.add(clearButton);
		clearButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				panel.clear();
			}
		});

		frame.add(subPanel, BorderLayout.SOUTH);
		frame.setSize(600, 400);
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.setLocationRelativeTo(null);
		frame.setVisible(true);
	}
}
