package tsp.method;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

import tsp.Node;

/**
 * 貪欲法による巡回セールスマン問題の構築法です。
 * @author ma38su
 */
public class Greedy implements TspTourConstruction {
	public List<Node> method(Collection<Node> place) {
		Set<Node> nodes = new HashSet<Node>(place);
		LinkedList<Node> route = new LinkedList<Node>();
		Set<Node> vp = new HashSet<Node>();
		Iterator<Node> itr = nodes.iterator();
		if (itr.hasNext()) {
			Node start = itr.next();
			Node node = start;
			while (!nodes.isEmpty()) {
				route.add(node);
				vp.add(node);
				nodes.remove(node);
				Node tmp = null;
				double min = Double.POSITIVE_INFINITY;
				for (Node terminal : nodes) {
					if (!node.equals(terminal) && !vp.contains(terminal)) {
						double distance = node.getDistance(terminal);
						if (min > distance) {
							min = distance;
							tmp = terminal;
						}
					}
				}
				node = tmp;
			}
			route.add(start);
		}
		return route;
	}

	@Override
	public String toString() {
		return "greedy(multiple fragment)";
	}
}
