package store;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import jp.sourceforge.ma38su.util.Log;

import map.DataCity;
import map.store.ChainStore;

/**
 * ミスドの店舗情報を取得するクラスです。
 * @author Masayasu Fujiwara
 */
public class MisterDonutPlugin extends ChainStore {

	private final Pattern ADDRESS_PARSER;

	public MisterDonutPlugin() {
		super("ミスド", "EUC-JP");
		this.ADDRESS_PARSER = Pattern.compile("<TD><font size=\"2\" class=\"tx\">([^<>]+)</font></TD");
	}

	@Override
	protected URL getURL(DataCity city, int page) {
		URL url = null;
		// TODO 一箇所に10店舗以上の地域がみつかっていない
		if (page == 1) {
			try {
				url = new URL("http://vip.mapion.co.jp/c/f?grp=misterdonut&uc=21&bool=admi2code&admi3=" + DataCity.cityFormat(city.getCode()));
			} catch (MalformedURLException e) {
				Log.err(this, e);
			}
		}
		return url;
	}

	@Override
	protected String parseAddress(String input) {
		Matcher matcher = this.ADDRESS_PARSER.matcher(input);
		if (matcher.find()) {
			return matcher.group(1);
		}
		return null;
	}
}
