package view;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;

import controller.MapController;
import controller.SearchController;
import controller.SearchEntry;

import database.CodeDatabase;

/**
 * 住所の検索パネル
 * @author ma38su
 */
public class SearchPanel extends JComponent {
	public SearchPanel(final CodeDatabase db, final MapController c) {
		this.setLayout(new BorderLayout(4, 4));
		final JTextField keywordField = new JTextField();
		JPanel keywordPanel = new JPanel(new BorderLayout(4, 4));
		final DefaultListModel list = new DefaultListModel();
		keywordPanel.add(keywordField, BorderLayout.CENTER);
		JButton searchButton = new JButton("検索");
		final JCheckBox geoCheck = new JCheckBox("Geocoding利用", true);
		ActionListener controller = new SearchController(c, db, list, keywordField, geoCheck);
		searchButton.addActionListener(controller);
		keywordField.addActionListener(controller);
		keywordPanel.add(searchButton, BorderLayout.EAST);
		keywordPanel.add(geoCheck, BorderLayout.SOUTH);
		this.setPreferredSize(new Dimension(200, 0));
		this.setMinimumSize(new Dimension(0, 0));
		JPanel resultPanel = new JPanel(new BorderLayout(4, 4));
		final JList resultList = new JList(list);
		resultList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		resultList.addMouseListener(new MouseListener() {
			public void mouseClicked(MouseEvent e) {
				if (e.getClickCount() == 2) {
					final SearchEntry entry = (SearchEntry) resultList.getSelectedValue();
					new Thread() {
						@Override
						public void run() {
							c.moveMap(entry);
						}
					}.start();
				}
			}
			public void mouseEntered(MouseEvent e) {
			}
			public void mouseExited(MouseEvent e) {
			}
			public void mousePressed(MouseEvent e) {
			}
			public void mouseReleased(MouseEvent e) {
			}
		});
		resultPanel.add(new JScrollPane(resultList));
		this.add(keywordPanel, BorderLayout.NORTH);
		this.add(resultPanel, BorderLayout.CENTER);
	}
}
