<?php

if ( function_exists('register_sidebar') ) {
	register_sidebar(array(
		'name' => 'navi',
		'before_widget' => "\t\t<dt id=\"".'%1$s'."\" class=\"widget ".'%2$s'."\">",
		'after_widget' => "\t\t</dd>\n",
		'before_title' => '',
		'after_title' => "</dt>\n\t\t<dd>\n",
	));
	register_sidebar(array(
		'name' => 'others',
		'before_widget' => "\t\t<dt id=\"".'%1$s'."\" class=\"widget ".'%2$s'."\">",
		'after_widget' => "\t\t</dd>\n",
		'before_title' => '',
		'after_title' => "</dt>\n\t\t<dd>\n",
	));
	/* Widget Override */
	wp_register_sidebar_widget('calendar', __('Calendar'), 'vicuna_widget_calendar');
	wp_register_sidebar_widget('search', __('Search'), 'vicuna_widget_search');
	wp_register_sidebar_widget('archives', __('Archives'), 'vicuna_widget_archives');
	register_widget_control('archives', 'vicuna_widget_archives_control');
	wp_register_sidebar_widget('pages', __('Pages'), 'vicuna_widget_pages');
	register_widget_control('pages', 'vicuna_widget_pages_control');
	wp_register_sidebar_widget('meta', __('Meta'), 'vicuna_widget_meta');
	register_widget_control('meta', 'vicuna_widget_meta_control');
	wp_register_sidebar_widget('recent-comments', __('Recent Comments'), 'vicuna_widget_recent_comments');
	register_widget_control('recent-comments', 'vicuna_widget_recent_comments_control');

	register_sidebar_widget('Feeds', 'vicuna_widget_feeds');
}

function check_widget_display($index, $widget_id) {
	global $wp_registered_sidebars;
	$index = sanitize_title($index);
	foreach ( $wp_registered_sidebars as $key => $value ) {
		if ( sanitize_title($value['name']) == $index ) {
			$index = $key;
			break;
		}
	}
	$sidebars_widgets = wp_get_sidebars_widgets();

	if ( !is_array($sidebars_widgets[$index]) || empty($sidebars_widgets[$index])) {
		return false;
	}

	foreach ($sidebars_widgets[$index] as $id) {
		if ($id == $widget_id) {
			return true;
		}
	}
	return false;
}

/**
 * Archives Widget
 */
function vicuna_widget_archives($args) {
	extract($args);
	$options = get_option('widget_archives');
	$title = empty($options['title']) ? __('Archives') : $options['title'];
	echo $before_widget . $before_title . $title . $after_title;
?>
			<ul>
<?php
	if ( $options['tree'] ) {
		get_vicuna_archives_tree_link();
	} else {
		get_vicuna_archives_link();
	}
?>
			</ul>
<?php
	echo $after_widget;
}

/**
 * Archives Widget Control
 */
function vicuna_widget_archives_control() {
	$options = $newoptions = get_option('widget_archives');
	if ( $_POST["archives-submit"] ) {
		$newoptions['tree'] = isset($_POST['archives-tree']);
		$newoptions['title'] = strip_tags(stripslashes($_POST["archives-title"]));
	}
	if ( $options != $newoptions ) {
		$options = $newoptions;
		update_option('widget_archives', $options);
	}
	$tree = $options['tree'] ? 'checked="checked"' : '';
	$title = attribute_escape($options['title']);
?>
			<p><label for="archives-title"><?php _e('Title:'); ?> <input style="width: 250px;" id="archives-title" name="archives-title" type="text" value="<?php echo $title; ?>" /></label></p>
			<p style="text-align:right;margin-right:40px;"><label for="archives-tree"><?php _e('Display as a trees'); ?> <input class="checkbox" type="checkbox" <?php echo $tree; ?> id="archives-tree" name="archives-tree" /></label></p>
			<input type="hidden" id="archives-submit" name="archives-submit" value="1" />
<?php
}


/**
 * Widget for Pages
 */
function vicuna_widget_pages($args) {
	extract($args);
	$options = get_option('widget_pages');
	$title = empty($options['title']) ? __('Pages') : $options['title'];
	$depth = empty($options['depth']) ? 0 : $options['depth'];
	echo $before_widget . $before_title . $title . $after_title . "<ul>\n";
	wp_list_pages('sort_column=menu_order&title_li=0&depth='. $depth);
	echo "</ul>\n" . $after_widget;
}

function vicuna_widget_pages_control() {
	$options = $newoptions = get_option('widget_pages');
	if ( $_POST["pages-submit"] ) {
		$newoptions['title'] = strip_tags(stripslashes($_POST["pages-title"]));
		$newoptions['depth'] = is_numeric($_POST["pages-depth"]) ? strip_tags(stripslashes($_POST["pages-depth"])) : null;
	}
	if ( $options != $newoptions ) {
		$options = $newoptions;
		update_option('widget_pages', $options);
	}
	$title = attribute_escape($options['title']);
	$depth = attribute_escape($options['depth']);
?>
			<p><label for="pages-title"><?php _e('Title:'); ?> <input style="width: 250px;" id="pages-title" name="pages-title" type="text" value="<?php echo $title; ?>" /></label></p>
			<p><label for="pages-depth"><?php _e('Depth:'); ?> <input style="width: 50px;" id="pages-depth" name="pages-depth" type="text" value="<?php echo $depth; ?>" /></label></p>
			<input type="hidden" id="pages-submit" name="pages-submit" value="1" />
<?php
}

/**
 * Widget for Calendar
 */
function vicuna_widget_calendar($args) {
	extract($args);
	$options = get_option('widget_calendar');
	$title = empty($options['title']) ? 'Calendar' : $options['title'];
	echo $before_widget . $before_title . $title . $after_title;
?>
	<?php get_vicuna_calendar(); ?>
<?php
	echo $after_widget;
}

/**
 * Control Widget for Calendar
 */
function vicuna_widget_calendar_control() {
	$options = $newoptions = get_option('widget_calendar');
	if ( $_POST["calendar-submit"] ) {
		$newoptions['title'] = strip_tags(stripslashes($_POST["calendar-title"]));
	}
	if ( $options != $newoptions ) {
		$options = $newoptions;
		update_option('widget_calendar', $options);
	}
	$title = attribute_escape($options['title']);
?>
			<p><label for="calendar-title"><?php _e('Title:'); ?> <input style="width: 250px;" id="calendar-title" name="calendar-title" type="text" value="<?php echo $title; ?>" /></label></p>
			<input type="hidden" id="calendar-submit" name="calendar-submit" value="1" />
<?php
}

/**
 * Widget for Search
 */
function vicuna_widget_search($args) {
	extract($args);
	$title = 'Search';
	echo $before_widget . $before_title . $title . $after_title;
?>
			<form method="get" action="<?php bloginfo('home'); ?>/">
				<fieldset>
					<legend><label for="searchKeyword"><?php bloginfo('name'); ?>内の検索</label></legend>
					<div>
						<input type="text" class="inputField" id="searchKeyword"  name="s" size="10" onfocus="if (this.value == 'Keyword(s)') this.value = '';" onblur="if (this.value == '') this.value = 'Keyword(s)';" value="<?php if ( is_search() ) echo wp_specialchars($s, 1); else echo 'Keyword(s)'; ?>" />
						<input type="submit" class="submit" id="submit" value="Search" />
					</div>
				</fieldset>
			</form>
<?php
	echo $after_widget;
}

function vicuna_widget_feeds($args) {
	extract($args);
	$options = get_option('widget_feeds');
	$title = empty($options['title']) ? 'Feeds' : $options['title'];
	echo $before_widget . $before_title . $title . $after_title;
?>
			<ul>
				<li class="rss"><a href="<?php bloginfo('rss2_url'); ?>">All Entries(RSS2.0)</a></li>
				<li class="atom"><a href="<?php bloginfo('atom_url'); ?>">All Entries(Atom)</a></li>
				<li class="rss"><a href="<?php bloginfo('comments_rss2_url'); ?>">All Comments(RSS2.0)</a></li>
			</ul>
<?php
	echo $after_widget;
}

function vicuna_widget_meta($args) {
	extract($args);
	$options = get_option('widget_meta');
	$title = empty($options['title']) ? __('Meta') : $options['title'];
	echo $before_widget . $before_title . $title . $after_title;
?>
			<ul>
				<li><a href="http://validator.w3.org/check/referer" title="This page validates as XHTML 1.0 Strict" rel="nofollow">Valid <abbr title="eXtensible HyperText Markup Language">XHTML</abbr></a></li>
<?php	wp_register(); ?>
				<li><?php wp_loginout(); ?></li>
<?php	wp_meta(); ?>
			</ul>
<?php
	echo $after_widget;
}

function vicuna_widget_meta_control() {
	$options = $newoptions = get_option('widget_meta');
	if ( $_POST["meta-submit"] ) {
		$newoptions['title'] = strip_tags(stripslashes($_POST["meta-title"]));
	}
	if ( $options != $newoptions ) {
		$options = $newoptions;
		update_option('widget_meta', $options);
	}
	$title = attribute_escape($options['title']);
?>
			<p><label for="meta-title"><?php _e('Title:'); ?> <input style="width: 250px;" id="meta-title" name="meta-title" type="text" value="<?php echo $title; ?>" /></label></p>
			<input type="hidden" id="meta-submit" name="meta-submit" value="1" />
<?php
}

function vicuna_widget_recent_comments($args) {
	extract($args);
	extract($args, EXTR_SKIP);
	$options = get_option('widget_recent_comments');
	$title = empty($options['title']) ? __('Recent Comments') : $options['title'];
	if ( !$number = (int) $options['number'] )
		$number = 5;
	else if ( $number < 1 )
		$number = 1;
	else if ( $number > 15 )
		$number = 15;

	echo $before_widget . $before_title . $title . $after_title;
	get_recent_comments_list($number);
	echo $after_widget;
}
function get_recent_comments_list($number = 5) {
	global $wpdb, $comments, $comment;
	if ( !$comments = wp_cache_get( 'recent_comments', 'widget' ) ) {
		$comments = $wpdb->get_results("SELECT comment_author, comment_author_url, comment_ID, comment_post_ID, comment_date FROM $wpdb->comments WHERE comment_approved = '1' ORDER BY comment_date_gmt DESC LIMIT $number");
		wp_cache_add( 'recent_comments', $comments, 'widget' );
	}
?>
			<ul id="recentcomments">
<?php			if ( $comments ) {
				$post_ID = -1;
				foreach ($comments as $comment) {
					if ($comment->comment_post_ID != $post_ID) {
						if ($post_ID >= 0) {
							echo "</ul></li>\n";
						}
						echo "\t\t\t" . '<li class="recentcomments"><a href="'. get_permalink($comment->comment_post_ID) . '#comments">' . get_the_title($comment->comment_post_ID) . '</a><ul>';
						$post_ID = $comment->comment_post_ID;
					}
					echo  '<li class="recentcomments"><a href="'.get_permalink($comment->comment_post_ID).'#comment-'.$comment->comment_ID.'">' . get_comment_time('Y-m-d') . ' ' . get_comment_author() . '</a></li>';
				}
			} ?></ul></li>
			</ul>
<?php
}

function vicuna_widget_recent_comments_control() {
	$options = $newoptions = get_option('widget_recent_comments');
	if ( $_POST["recent-comments-submit"] ) {
		$newoptions['title'] = strip_tags(stripslashes($_POST["recent-comments-title"]));
		$newoptions['number'] = (int) $_POST["recent-comments-number"];
	}
	if ( $options != $newoptions ) {
		$options = $newoptions;
		update_option('widget_recent_comments', $options);
		wp_delete_recent_comments_cache();
	}
	$title = attribute_escape($options['title']);
	if ( !$number = (int) $options['number'] )
		$number = 5;
?>
			<p><label for="recent-comments-title"><?php _e('Title:'); ?> <input style="width: 250px;" id="recent-comments-title" name="recent-comments-title" type="text" value="<?php echo $title; ?>" /></label></p>
			<p><label for="recent-comments-number"><?php _e('Number of comments to show:'); ?> <input style="width: 25px; text-align: center;" id="recent-comments-number" name="recent-comments-number" type="text" value="<?php echo $number; ?>" /></label> <?php _e('(at most 15)'); ?></p>
			<input type="hidden" id="recent-comments-submit" name="recent-comments-submit" value="1" />
<?php
}

/**
 * ページ分割(Newer | Older)へのリンクを表示します。
 */
function paging_link($args = '') {
	global $paged, $wpdb, $wp_query;

	if (is_array($args))
		$r = &$args;
	else
		parse_str($args, $r);

	$defaults = array('next_label' => 'Next Page', 'prev_label' => 'Previous Page', 'indent' => '');
	$r = array_merge($defaults, $r);
	extract($r);

	if ($indent != '') {
		$indent = (int) $indent;

		for ($i = 0; $i < $indent; $i ++)
			$indentText .= "\t";
	}

	// max_page を取得
	if (!$max_page)
		$max_page = $wp_query->max_num_pages;

	// paged を取得
	if (!$paged)
		$paged = 1;

	// 次ページのページ番号を設定
	$nextpage = intval($paged) + 1;

	if(!is_single()) {
		if ($max_page > 1)
			echo "$indentText<ul class=\"flip pager\" id=\"flip2\">\n";
		if ($paged > 1) {
			echo "$indentText\t<li class=\"newer\"><a href=\"";
			previous_posts();
			echo '">'. preg_replace('/&([^#])(?![a-z]{1,8};)/', '&#038;$1', $prev_label) ."</a></li>\n";
		}
		if (empty($paged) || $nextpage <= $max_page) {
			echo "$indentText\t<li class=\"older\"><a href=\"";
			next_posts($max_page);
			echo '">'. preg_replace('/&([^#])(?![a-z]{1,8};)/', '&#038;$1', $next_label) ."</a></li>\n";
		}
		if ($max_page > 1)
			echo $indentText . '</ul>' . "\n";
	}
}

/**
 * エントリー本文にインデントを付加します。
 */
function indent_entry_body($content) {
	// インデント数 (div.textBody p から見て)
	$indent = '4';

	if ($indent != '') {
		$indent = (int) $indent;

		for ($i = 0; $i < $indent; $i ++)
			$indentText .= "\t";
	} else {
		$indentText = "\t\t\t\t";
	}

	$pre_flag = false;
	$arr_content = split("\n", $content);

	foreach ($arr_content as $line) {
		if(!$pre_flag) {
			if (strpos($line, "<pre") !== false)
				$pre_flag = true;

			$mes .= $indentText . $line . "\n";
		}
		else {
			if (strpos($line, "</pre>") !== false)
				$pre_flag = false;

			$mes .= $line . "\n";
		}
	}

	return rtrim($mes) . "\n";
}

add_action('the_content', indent_entry_body, 99);

/**
 * エントリー本文の追記情報を置換します。
 */
function replace_entry_body($content) {
	// インデント数 (div.textBody から見て)
	$indent = '3';

	if ($indent != '') {
		$indent = (int) $indent;

		for ($i = 0; $i < $indent; $i ++)
			$indentText .= "\t";
	} else {
		$indentText = "\t\t\t\t";
	}

	// エントリータイトルを取得
	$entry_title = get_the_title();

	if (is_page() || is_single()) {
		// [2007-04-03]
		// <p><a id="more-**"></p>を<div class="textBody" id="extended">に置き換える
		// $content = preg_replace('/\t<p(\s.+?=".+?">|>)<a id="more-([0-9]+?)"><\/a>(.*?)<\/p>/', "</div>\n$indentText<div class=\"textBody\" id=\"extended\">\n$indentText\t<p\\1\\3</p>", $content);

		// [追記 by ma38su]
		// <a class="more-link">が、<p>から始まらない場合の<a id="more-**">を<div class="textBody" id="extended">に置き換える
		// $content = preg_replace('/<a id="more-([0-9]+?)"><\/a>(.*?)<\/p>/', "</p>\n\t\t\t</div>\n$indentText<div class=\"textBody\" id=\"extended\">\n$indentText\t<p>\\2</p>", $content);

		// [追記 by ma38su]
		$content = preg_replace('/\s*<p><span id="more-([0-9]+?)"><\/span>(.*?)<\/p>/', "\n\t\t\t</div>\n$indentText<div class=\"textBody\" id=\"extended\">\n$indentText\t<p>\\2</p>", $content);

		// [追記 by ma38su]
		$content = preg_replace('/\s*<span id="more-([0-9]+?)"><\/span>(.*?)<\/p>/', "\t</p>\n\t\t\t</div>\n$indentText<div class=\"textBody\" id=\"extended\">\n$indentText\t<p>\\2</p>", $content);

		// [追記 by ma38su]
		$content = preg_replace('/\s*<p><span id="more-([0-9]+?)"><\/span>(.*?)<br\s*\/>/', "\n\t\t\t</div>\n$indentText<div class=\"textBody\" id=\"extended\">\n<p>$indentText\t<p>\\2</p>", $content);

	} else {
		// [2007-04-03]
		// <p><a class="more-link">を<p class="continue"><a>に置き換える (href="hoge#more-**"を、href="hoge#extended"に置換)
		$content = preg_replace('/<p(\s.+?=".+?">|>)\s?<a href="(.+?)#more-([0-9]+?)" class="more-link">(.+?)<\/a><\/p>/', '<p class="continue"><a href="\2#extended" title="' . $entry_title . ' 全文を読む" rel="nofollow">\4</a></p>', $content);

		// [追記 by ma38su]
		// <p>から始まらない場合の<a class="more-link">を<p class="continue"><a>に置き換える
		$content = preg_replace('/\s*<a href="(.+?)#more-([0-9]+?)" class="more-link">(.+?)<\/a><\/p>/', "</p>\n\t\t\t\t".'<p class="continue"><a href="\1#extended" title="' . $entry_title . ' 全文を読む" rel="nofollow">\3</a></p>', $content);

	}
	// [2007-04-03]
	// <p></p>, <p class="hoge"></p>, <p>&nbsp;</p>, <p class="hoge">&nbsp;</p>などを置換
	$content = preg_replace('/\t*<p(\s.+?=".+?">|>)\s*?<\/p>\n/', '', $content);

	// [追記 by ma38su]
	// <br /></p>の削除
	$content = preg_replace("/<br \/>\s*<\/p>/", "</p>", $content); 

	return $content;
}

add_action('the_content', replace_entry_body, 100);

/**
 * コメント本文にインデントを付加します。
 */
function indent_comment_body($content) {
	// インデント数 (dl.log dd p から見て)
	$indent = '7';

	if ($indent != '') {
		$indent = (int) $indent;

		for ($i = 0; $i < $indent; $i ++)
			$indentText .= "\t";
	} else {
		$indentText = "\t\t\t\t\t";
	}

	$pre_flag = false;
	$arr_content = split("\n", $content);

	foreach ($arr_content as $line) {
		if(!$pre_flag) {
			if (strpos($line, "<pre") !== false)
				$pre_flag = true;

			$mes .= $indentText . $line . "\n";
		}
		else {
			if (strpos($line, "</pre>") !== false)
				$pre_flag = false;

			$mes .= $line . "\n";
		}
	}

	return rtrim($mes) . "\n";
}

add_filter('comment_text', indent_comment_body, 100);

/**
 * テーマ独自のJavascriptのURLを取得します。
 */
function get_javascript_uri() {
	$javascript_uri = get_stylesheet_directory_uri() . "/script.js";
	return $javascript_uri;
}

/**
 * 日時のアーカイブのタイトルを取得します。
 */
function get_archive_title() {
	if (is_day()) { /* If this is a daily archive */
		// [2007-04-03 変更部分]
		// return get_the_time('Y年 m月 d日');
		return get_the_time('Y-m-d');
	} elseif (is_month()) { /* If this is a monthly archive */
		// [2007-04-03 変更部分]
		// return get_the_time('Y年 m月');
		return get_the_time('F, Y');
	} elseif (is_year()) { /* If this is a yearly archive */
		// [2007-04-03 変更部分]
		// return get_the_time('Y年');
		return get_the_time('Y');
	} elseif (is_author()) {
		return 'Author';
	}
}

function get_page_location($separator = ' &raquo; ') {
	$output = '';
	$current_page = 0;
	if ( is_page() ) {
		$pages = get_pages();
		if ( !empty($pages) ) {
			global $wp_query;
			$current_page = $wp_query->get_queried_object_id();
			$flag = false;
			$output = '';
			$family = pick_page_parents($pages, array(), $current_page);
			array_shift($family);
			foreach ($family as $page) {
				$output = $page->post_title . $separator .  $output;
			}
			return $output;
		}
	}
}

function get_page_location_link($separator = ' &gt; ') {
	$output = '';
	$current_page = 0;
	if ( is_page() ) {
		$pages = get_pages();
		if ( !empty($pages) ) {
			global $wp_query;
			$current_page = $wp_query->get_queried_object_id();
			$flag = false;
			$output = '';
			$family = pick_page_parents($pages, array(), $current_page);
			array_shift($family);
			foreach ($family as $page) {
				if ( $flag ) {
					$output = $separator . $output;
				} else {
					$flag = true;
				}
				$output = '<a href="' .get_permalink($page->ID). "\">$page->post_title</a>". $output;
			}
			return $output;
		}
	}
}

function pick_page_parents($pages, $family, $page_id) {
	foreach ($pages as $page) {
		if ($page_id == $page->ID) {
			if (array_push($family, $page)) {
				$family = pick_page_parents($pages, $family, $page->post_parent);
				break;
			}
		}
	}
	return $family;
}

/**
 * アーカイブリンクリスト
 */
function get_vicuna_archives_link($limit = '') {
        global $wp_locale, $wpdb;

        if ( '' != $limit ) {
                $limit = (int) $limit;
                $limit = ' LIMIT '.$limit;
        }

        $arcresults = $wpdb->get_results("SELECT DISTINCT YEAR(post_date) AS `year`, MONTH(post_date) AS `month`, count(ID) as posts FROM $wpdb->posts WHERE post_type = 'post' AND post_status = 'publish' GROUP BY YEAR(post_date), MONTH(post_date) ORDER BY post_date DESC" . $limit);
        if ( $arcresults ) {
                foreach ( $arcresults as $arcresult ) {
                        $url    = get_month_link($arcresult->year,      $arcresult->month);
			// [2007-04-03 変更部分]
			// $text = wptexturize(sprintf(__('%1$s %2$d'), $wp_locale->get_month($arcresult->month), $arcresult->year));
			$text	= sprintf("%04d-%02d", $arcresult->year, $arcresult->month);
			echo "\t<li><a href=\"$url\" title=\"$arcresult->posts\" rel=\"nofollow\">$text</a></li>\n";
		}
	}
}

/**
 * アーカイブリンクリスト
 * 年と月を階層的に表示させます。
 */
function get_vicuna_archives_tree_link($limit = '') {
        global $wp_locale, $wpdb;

        if ( '' != $limit ) {
                $limit = (int) $limit;
                $limit = ' LIMIT '.$limit;
        }

        $arcresults = $wpdb->get_results("SELECT DISTINCT YEAR(post_date) AS `year`, MONTH(post_date) AS `month`, count(ID) as posts FROM $wpdb->posts WHERE post_type = 'post' AND post_status = 'publish' GROUP BY YEAR(post_date), MONTH(post_date) ORDER BY post_date DESC" . $limit);
	$year = 0;
        if ( $arcresults ) {
                foreach ( $arcresults as $arcresult ) {
			if ($year != $arcresult->year) {
				if ($year != 0) {
					echo "\t\t\t\t</ul></li>\n";
				}
				$year = $arcresult->year;
				echo "\t\t\t\t<li><a href=\"". get_year_link($year) . "\" title=\"$year Archives\" rel=\"nofollow\">$year</a>\n\t\t\t\t<ul>\n";
			}
                        $url = get_month_link($arcresult->year, $arcresult->month);
			// [2007-04-03 変更部分]
			// $text = wptexturize(sprintf(__('%1$s %2$d'), $wp_locale->get_month($arcresult->month), $arcresult->year));
			// $text = sprintf("%04d-%02d", $arcresult->year, $arcresult->month);
			$text = wptexturize(sprintf(__('%1$s'), $wp_locale->get_month($arcresult->month)));
			echo "\t\t\t\t\t<li><a href=\"$url\" title=\"$arcresult->posts\" rel=\"nofollow\">$text</a></li>\n";
                }
		if ($year) {
			echo "\t\t\t\t</ul></li>\n";
		}
}
}

/**
 * 親カテゴリのみを取得します。
 */
function get_category_only_parents($cat_id, $category_split = ' | ') {
	$parent = &get_category($cat_id);
	$name = $parent->cat_name;
	$flag = true;
	$parent_category = '';
	while ( $parent->category_parent ) {
		$tmp = '';
		$parent = &get_category($parent->category_parent);
		$tmp .= '<a href="'. get_category_link($parent->cat_ID).'">'.$parent->cat_name.'</a>';
		if ($flag) {
			$flag = false;
		} else {
			$tmp .= $category_split;
		}
		$parent_category = $tmp.$output;
	}
	return $parent_category;
}

/**
 * TrackbackとPingbackの和を取得します。
 */
function get_trackping_count() {
	global $post, $wpdb, $id;
	$comments = $wpdb->get_results("SELECT * FROM $wpdb->comments WHERE comment_post_ID = '$post->ID' AND comment_approved = '1' AND comment_type != '' ORDER BY comment_date");
	// $comments = apply_filters( 'comments_array', $comments, $post->ID );
	return count($comments);
}

/**
 * 全記事を取得します。
 */
function get_all_posts() {
	global $wpdb;
	$posts = $wpdb->get_results("SELECT * FROM $wpdb->posts WHERE post_type = 'post' AND post_status = 'publish' ORDER BY ID DESC");
	// $comments = apply_filters( 'comments_array', $comments, $post->ID );
	return $posts;
}

/**
 * 全コメントを取得します。
 */
function get_all_comments() {
	global $wpdb;
	$comments = $wpdb->get_results("SELECT * FROM $wpdb->comments WHERE comment_approved = '1' AND comment_type = '' ORDER BY comment_date");
	// $comments = apply_filters( 'comments_array', $comments, $post->ID );
	return $comments;
}

/**
 * 各投稿毎のコメントを一括で編集するためのリンクを表示させます。
 * 現在、ページに対しては対応してないようです。
 */
function edit_post_comments_link($link = 'Edit This Comments.', $before = '', $after = '') {
        global $post;
        if ( is_attachment() )
                return;

        if( $post->post_type == 'page' ) {
		return;
		/*
                if ( ! current_user_can('edit_page', $post->ID) )
                        return;
                $file = 'page';
		*/
        } else {
                if ( ! current_user_can('edit_post', $post->ID) )
                        return;
                $file = 'post';
        }

		// [2007-04-03 変更部分]
        // $location = get_option('siteurl') . "/wp-admin/edit.php?p=$post->ID&c=1";
		$location = get_option('siteurl') . "/wp-admin/edit.php?p=$post->ID&amp;c=1";
        echo $before . "<a href=\"$location\">$link</a>" . $after;
}

/**
 * vicunaに対応したカレンダーを表示させます。
 */
function get_vicuna_calendar($initial = true) {
	$weekday = array('Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday');
	global $wpdb, $m, $monthnum, $year, $timedifference, $wp_locale, $posts;

	$key = md5( $m . $monthnum . $year );
	if ( $cache = wp_cache_get( 'get_vicuna_calendar', 'calendar' ) ) {
		if ( isset( $cache[ $key ] ) ) {
			echo $cache[ $key ];
			return;
		}
	}

	ob_start();
	// Quick check. If we have no posts at all, abort!
	if ( !$posts ) {
		$gotsome = $wpdb->get_var("SELECT ID from $wpdb->posts WHERE post_type = 'post' AND post_status = 'publish' ORDER BY post_date DESC LIMIT 1");
		if ( !$gotsome )
			return;
	}

	if ( isset($_GET['w']) )
		$w = ''.intval($_GET['w']);

	// week_begins = 0 stands for Sunday
	$week_begins = intval(get_option('start_of_week'));
	$add_hours = intval(get_option('gmt_offset'));
	$add_minutes = intval(60 * (get_option('gmt_offset') - $add_hours));

	// Let's figure out when we are
	if ( !empty($monthnum) && !empty($year) ) {
		$thismonth = ''.zeroise(intval($monthnum), 2);
		$thisyear = ''.intval($year);
	} elseif ( !empty($w) ) {
		// We need to get the month from MySQL
		$thisyear = ''.intval(substr($m, 0, 4));
		$d = (($w - 1) * 7) + 6; //it seems MySQL's weeks disagree with PHP's
		$thismonth = $wpdb->get_var("SELECT DATE_FORMAT((DATE_ADD('${thisyear}0101', INTERVAL $d DAY) ), '%m')");
	} elseif ( !empty($m) ) {
		$calendar = substr($m, 0, 6);
		$thisyear = ''.intval(substr($m, 0, 4));
		if ( strlen($m) < 6 )
				$thismonth = '01';
		else
				$thismonth = ''.zeroise(intval(substr($m, 4, 2)), 2);
	} else {
		$thisyear = gmdate('Y', current_time('timestamp'));
		$thismonth = gmdate('m', current_time('timestamp'));
	}

	$unixmonth = mktime(0, 0 , 0, $thismonth, 1, $thisyear);

	// Get the next and previous month and year with at least one post
	$previous = $wpdb->get_row("SELECT DISTINCT MONTH(post_date) AS month, YEAR(post_date) AS year
		FROM $wpdb->posts
		WHERE post_date < '$thisyear-$thismonth-01'
		AND post_type = 'post' AND post_status = 'publish'
			ORDER BY post_date DESC
			LIMIT 1");
	$next = $wpdb->get_row("SELECT	DISTINCT MONTH(post_date) AS month, YEAR(post_date) AS year
		FROM $wpdb->posts
		WHERE post_date >	'$thisyear-$thismonth-01'
		AND MONTH( post_date ) != MONTH( '$thisyear-$thismonth-01' )
		AND post_type = 'post' AND post_status = 'publish'
			ORDER	BY post_date ASC
			LIMIT 1");

	echo '
			<table class="calendar" cellpadding="0" cellspacing="0" summary="Monthly calendar">
				<caption>
';
	if ( $previous ) {
		echo '<a href="' . get_month_link($previous->year, $previous->month) . '" title="Older" rel="nofollow">&laquo;</a>';
	} else {
		echo '&laquo;';
	}
	echo ' ' . date('Y', $unixmonth) . ' ' . $wp_locale->get_month($thismonth) . ' ';
	if ( $next ) {
		echo '<a href="' . get_month_link($next->year, $next->month) . '" title="Newer">&raquo;</a></td>';
	} else {
		echo '&raquo;';
	}

        $myweek = array();

        for ( $wdcount=0; $wdcount<=6; $wdcount++ ) {
		// $myweek[] = $wp_locale->get_weekday(($wdcount+$week_begins)%7);
		$myweek[] = $weekday[ ($wdcount + $week_begins) % 7];
        }


	echo '</caption>
				<tr>
';
        foreach ( $myweek as $wd ) {
                // $day_name = (true == $initial) ? $wp_locale->get_weekday_initial($wd) : $wp_locale->get_weekday_abbrev($wd);
		$day_name = mb_substr( $wd, 0, 1 );
		if ($day_name == "S") {
                	echo "\t\t\t\t\t<th class=\"". strtolower(substr( $wd, 0, 3)) ."\" title=\"$wd\">$day_name</th>\n";
		} else {
                	echo "\t\t\t\t\t<th title=\"$wd\">$day_name</th>\n";
		}
        }
	echo '
				</tr>
				<tr>
';

	// Get days with posts
	$dayswithposts = $wpdb->get_results("SELECT DISTINCT DAYOFMONTH(post_date)
		FROM $wpdb->posts WHERE MONTH(post_date) = '$thismonth'
		AND YEAR(post_date) = '$thisyear'
		AND post_type = 'post' AND post_status = 'publish'
		AND post_date < '" . current_time('mysql') . '\'', ARRAY_N);
	if ( $dayswithposts ) {
		foreach ( $dayswithposts as $daywith ) {
			$daywithpost[] = $daywith[0];
		}
	} else {
		$daywithpost = array();
	}

	if ( strstr($_SERVER['HTTP_USER_AGENT'], 'MSIE') || strstr(strtolower($_SERVER['HTTP_USER_AGENT']), 'camino') || strstr(strtolower($_SERVER['HTTP_USER_AGENT']), 'safari') )
		$ak_title_separator = "\n";
	else
		$ak_title_separator = ', ';

	$ak_titles_for_day = array();
	$ak_post_titles = $wpdb->get_results("SELECT post_title, DAYOFMONTH(post_date) as dom "
		."FROM $wpdb->posts "
		."WHERE YEAR(post_date) = '$thisyear' "
		."AND MONTH(post_date) = '$thismonth' "
		."AND post_date < '".current_time('mysql')."' "
		."AND post_type = 'post' AND post_status = 'publish'"
	);
	if ( $ak_post_titles ) {
		foreach ( $ak_post_titles as $ak_post_title ) {
				if ( empty($ak_titles_for_day['day_'.$ak_post_title->dom]) )
					$ak_titles_for_day['day_'.$ak_post_title->dom] = '';
				if ( empty($ak_titles_for_day["$ak_post_title->dom"]) ) // first one
					$ak_titles_for_day["$ak_post_title->dom"] = str_replace('"', '&quot;', wptexturize($ak_post_title->post_title));
				else
					$ak_titles_for_day["$ak_post_title->dom"] .= $ak_title_separator . str_replace('"', '&quot;', wptexturize($ak_post_title->post_title));
		}
	}

	// See how much we should pad in the beginning
	$pad = calendar_week_mod(date('w', $unixmonth)-$week_begins);
	if ( 0 != $pad ) {
		for ($i = 0; $i < $pad; $i++)
			echo "\t\t\t\t\t<td>&nbsp;</td>\n";
	}

	$daysinmonth = intval(date('t', $unixmonth));
	for ( $day = 1; $day <= $daysinmonth; ++$day ) {
		if ( isset($newrow) && $newrow )
			echo "\n\t\t\t\t</tr>\n\t\t\t\t<tr>\n";
		$newrow = false;

		if ( $day == gmdate('j', (time() + (get_option('gmt_offset') * 3600))) && $thismonth == gmdate('m', time()+(get_option('gmt_offset') * 3600)) && $thisyear == gmdate('Y', time()+(get_option('gmt_offset') * 3600)) )
			echo "\t\t\t\t\t<td class=\"today\">";
		else
			echo "\t\t\t\t\t<td>";

		if ( in_array($day, $daywithpost) ) // any posts today?
				echo '<a href="' . get_day_link($thisyear, $thismonth, $day) . "\" title=\"$ak_titles_for_day[$day]\">$day</a>";
		else
			echo $day;
		echo "</td>\n";

		if ( 6 == calendar_week_mod(date('w', mktime(0, 0 , 0, $thismonth, $day, $thisyear))-$week_begins) )
			$newrow = true;
	}

	$pad = 7 - calendar_week_mod(date('w', mktime(0, 0 , 0, $thismonth, $day, $thisyear))-$week_begins);
	if ( $pad != 0 && $pad != 7 ) {
		for ($i = 0; $i < $pad; $i++)
			echo "\t\t\t\t\t<td>&nbsp;</td>\n";
	}

	echo "\t\t\t\t</tr>\n\t\t\t</table>\n";

	$output = ob_get_contents();
	ob_end_clean();
	echo $output;
	$cache[ $key ] = $output;
	wp_cache_set( 'get_vicuna_calendar', $cache, 'calendar' );
}
function delete_get_vicuna_calendar_cache() {
	wp_cache_delete( 'get_vicuna_calendar', 'calendar' );
}

/**
 * vicuna options 管理画面
 */
function add_vicuna_options() {
?>
<div class="wrap">
	<h2>Vicuna Options</h2>
	<p>You can customize the vicuna theme.</p>
	<form method="post" action="<?php echo $_SERVER['PHP_SELF'] . '?page=' . basename(__FILE__); ?>">
		<dl>
			<dt>Skin</dt>
			<dd><select name="vicuna_skin">
<?php
	$skin = get_option('vicuna_skin');
	foreach (get_skin_dirs() as $file) : ?>
				<option<?php if ($file == $skin) : echo ' selected'; endif; ?>><?php echo $file; ?></option>
<?php	endforeach; ?>
			</select></dd>
			<dt>Eye Catch</dt>
<?php	$eye_catch = get_option('vicuna_eye_catch'); ?>
			<dd><select name="vicuna_eye_catch">
				<option value="0">none</option>
				<option value="long"<?php if ($eye_catch == 'long') : echo ' selected'; endif; ?>>Long</option>
				<option value="short"<?php if ($eye_catch == 'short') : echo ' selected'; endif; ?>>Shirt</option>
				<option value="mini"<?php if ($eye_catch == 'mini') : echo ' selected'; endif; ?>>Mini</option>
				<option value="header"<?php if ($eye_catch == 'header') : echo ' selected'; endif; ?>>Header</option>
			</select></dd>
			<dt>Feed Type</dt>
			<dd><select name="vicuna_feed_type">
				<option value="0">wp default</option>
				<option value="rss+xml"<?php if (get_option('vicuna_feed_type') == 'rss+xml') : ?> selected<?php endif; ?>>rss+xml</option>
				<option value="atom+xml"<?php if (get_option('vicuna_feed_type') == 'atom+xml') : ?> selected<?php endif; ?>>atom+xml</option>
			</select></dd>
			<dt>Feed URL</dt>
			<dd><input type="text" name="vicuna_feed_url" value="<?php	echo get_option('vicuna_feed_url'); ?>" /></dd>
		</dl>
		<h3>Navigation</h3>
		<dt>
			<dt>Global Navigation</dt>
			<dd><select name="vicuna_g_navi_display">
				<option value="0">none</option>
				<option value="1"<?php if (get_option('vicuna_g_navi_display')) : ?> selected<?php endif; ?>>pages</option>
			</select>
			<select name="vicuna_g_navi_home">
				<option value="0">hide Home</option>
				<option value="1"<?php if (get_option('vicuna_g_navi_home')) : ?> selected<?php endif; ?>>display Home</option>
			</select></dd>
			<dt>Directions form Older to Newer</dt>
			<dd><select name="vicuna_flip_direction">
				<option value="0">Newer - Older</option>
				<option value="1"<?php if (get_option('vicuna_flip_direction')) : ?> selected<?php endif; ?>>Older - Newer</option>
			</select></dd>
			<dt>Older Label</dt>
			<dd><input type="text" name="vicuna_older_label" value="<?php $older_label = get_option('vicuna_older_label'); if ( empty($older_label) ) $older_label = "Older"; echo $older_label; ?>" /></dd>
			<dt>Newer Label</dt>
			<dd><input type="text" name="vicuna_newer_label" value="<?php $newer_label = get_option('vicuna_newer_label'); if ( empty($newer_label) ) $newer_label = "Newer"; echo $newer_label; ?>" /></dd>
		</dl>
<?php	$layout_index = get_option('vicuna_index_layout'); ?>
		<h3>Layout</h3>
		<dl>
			<dt>Index Layout</dt>
			<dd><select name="vicuna_index_layout">
				<option value="single"<?php if ($layout_index == "single") : echo ' selected'; endif; ?>>Single column</option>
				<option value="double"<?php if (!$layout_index || $layout_index == "double") : echo ' selected'; endif; ?>>2column</option>
				<option value="multi"<?php if ($layout_index == "multi") : echo ' selected'; endif; ?>>3column</option>
			</select></dd>
<?php	$layout_category = get_option('vicuna_category_layout'); ?>
			<dt>Category Layout</dt>
			<dd><select name="vicuna_category_layout">
				<option value="single"<?php if ($layout_category == "single") : echo ' selected'; endif; ?>>Single column</option>
				<option value="double"<?php if (!$layout_category || $layout_category == "double") : echo ' selected'; endif; ?>>2column</option>
				<option value="multi"<?php if ($layout_category == "multi") : echo ' selected'; endif; ?>>3column</option>
			</select></dd>
<?php	$layout_archive = get_option('vicuna_archive_layout'); ?>
			<dt>Archives Layout</dt>
			<dd><select name="vicuna_archive_layout">
				<option value="single"<?php if ($layout_archive == "single") : echo ' selected'; endif; ?>>Single column</option>
				<option value="double"<?php if (!$layout_archive || $layout_archive == "double") : echo ' selected'; endif; ?>>2column</option>
				<option value="multi"<?php if ($layout_archive == "multi") : echo ' selected'; endif; ?>>3column</option>
			</select></dd>
<?php	$layout_single = get_option('vicuna_single_layout'); ?>
			<dt>Single Layout</dt>
			<dd><select name="vicuna_single_layout">
				<option value="single"<?php if (!$layout_single || $layout_single == "single") : echo ' selected'; endif; ?>>Single column</option>
				<option value="double"<?php if ($layout_single == "double") : echo ' selected'; endif; ?>>2column</option>
				<option value="multi"<?php if ($layout_single == "multi") : echo ' selected'; endif; ?>>3column</option>
			</select></dd>
<?php	$layout_page = get_option('vicuna_page_layout'); ?>
			<dt>Page Layout</dt>
			<dd><select name="vicuna_page_layout">
				<option value="single"<?php if (!$layout_page || $layout_page == "single") : echo ' selected'; endif; ?>>Single column</option>
				<option value="double"<?php if ($layout_page == "double") : echo ' selected'; endif; ?>>2column</option>
				<option value="multi"<?php if ($layout_page == "multi") : echo ' selected'; endif; ?>>3column</option>
			</select></dd>
<?php	$layout_search = get_option('vicuna_search_layout'); ?>
			<dt>Search Layout</dt>
			<dd><select name="vicuna_search_layout">
				<option value="single"<?php if (!$layout_search || $layout_search == "single") : echo ' selected'; endif; ?>>Single column</option>
				<option value="double"<?php if ($layout_search == "double") : echo ' selected'; endif; ?>>2column</option>
				<option value="multi"<?php if ($layout_search == "multi") : echo ' selected'; endif; ?>>3column</option>
			</select></dd>
<?php	$layout_404 = get_option('vicuna_404_layout'); ?>
			<dt>404 Layout</dt>
			<dd><select name="vicuna_404_layout">
				<option value="single"<?php if (!$layout_404 || $layout_404 == "single") : echo ' selected'; endif; ?>>Single column</option>
				<option value="double"<?php if ($layout_404 == "double") : echo ' selected'; endif; ?>>2column</option>
				<option value="multi"<?php if ($layout_404 == "multi") : echo ' selected'; endif; ?>>3column</option>
			</select></dd>
			<dt>Multi Layout Type</dt>
			<dd><select name="vicuna_3column_type">
				<option value="0">Type 1</option>
				<option value="1"<?php if (get_option('vicuna_3column_type')) : echo ' selected'; endif; ?>>Type 2</option>
			</select></dd>
<?php	/*		<dt>2column Layout Type</dt>
			<dd><select name="vicuna_2column_type">
				<option>Right menu</option>
				<option>Left menu</option>
			</select></dd> */ ?>
		</dl>
		<input type="submit" value="Save Changes" />

  	</form>
</div>
<?php
}
function add_vicuna_options_menu() {
	add_theme_page('Vicuna Options', 'Vicuna Options', 0, basename(__FILE__), 'add_vicuna_options');
}

/**
 * パラメータの更新するための関数
 */
function update_vicuna_options() {
	if (isset($_POST['vicuna_skin'])) {
		update_option('vicuna_skin', $_POST['vicuna_skin']);
	}
	if (isset($_POST['vicuna_feed_type'])) {
		update_option('vicuna_feed_type', $_POST['vicuna_feed_type']);
	}
	if (isset($_POST['vicuna_feed_url'])) {
		update_option('vicuna_feed_url', $_POST['vicuna_feed_url']);
	}
	if (isset($_POST['vicuna_eye_catch'])) {
		update_option('vicuna_eye_catch', $_POST['vicuna_eye_catch']);
	}
	if (isset($_POST['vicuna_g_navi_display'])) {
		update_option('vicuna_g_navi_display', $_POST['vicuna_g_navi_display']);
	}
	if (isset($_POST['vicuna_g_navi_home'])) {
		update_option('vicuna_g_navi_home', $_POST['vicuna_g_navi_home']);
	}
	if (isset($_POST['vicuna_flip_direction'])) {
		update_option('vicuna_flip_direction', $_POST['vicuna_flip_direction']);
	}
	if (isset($_POST['vicuna_older_label'])) {
		update_option('vicuna_older_label', $_POST['vicuna_older_label']);
	}
	if (isset($_POST['vicuna_newer_label'])) {
		update_option('vicuna_newer_label', $_POST['vicuna_newer_label']);
	}
	if (isset($_POST['vicuna_3column_type'])) {
		update_option('vicuna_3column_type', $_POST['vicuna_3column_type']);
	}
	if (isset($_POST['vicuna_pages_depth'])) {
		update_option('vicuna_pages_depth', get_option('vicuna_pages_type') == 1 ? 1 : $_POST['vicuna_pages_depth']);
	}
	if (isset($_POST['vicuna_index_layout'])) {
		update_option('vicuna_index_layout', $_POST['vicuna_index_layout']);
	}
	if (isset($_POST['vicuna_category_layout'])) {
		update_option('vicuna_category_layout', $_POST['vicuna_category_layout']);
	}
	if (isset($_POST['vicuna_archive_layout'])) {
		update_option('vicuna_archive_layout', $_POST['vicuna_archive_layout']);
	}
	if (isset($_POST['vicuna_page_layout'])) {
		update_option('vicuna_page_layout', $_POST['vicuna_page_layout']);
	}
	if (isset($_POST['vicuna_single_layout'])) {
		update_option('vicuna_single_layout', $_POST['vicuna_single_layout']);
	}
	if (isset($_POST['vicuna_search_layout'])) {
		update_option('vicuna_search_layout', $_POST['vicuna_search_layout']);
	}
	if (isset($_POST['vicuna_404_layout'])) {
		update_option('vicuna_404_layout', $_POST['vicuna_404_layout']);
	}
}

function get_skin_dirs() {
	$theme_dir = get_theme_local_path();
	if ($dir = opendir($theme_dir)) {
		while (($file = readdir($dir)) !== false) {
			if ($file != "." && $file != ".." && is_dir($theme_dir . '/'. $file) && mb_substr($file, 0, 6) == 'style-') {
				$files[] = $file;
			}
		} 
		closedir($dir);
	}
	return $files;
}

function get_skin_uri() {
	$skin = get_option('vicuna_skin');
	if (!$skin) $skin = 'style-vega';
	return get_bloginfo('template_url') .'/'. $skin;
}

function get_theme_local_path() {
	$cwd = getcwd();
	$theme_dir = get_bloginfo('template_directory');
	return mb_substr( $cwd, 0, strlen($cwd) - 8) . mb_substr( $theme_dir, mb_strrpos($theme_dir, 'wp-content'));
}

add_action( 'save_post', 'delete_get_vicuna_calendar_cache' );
add_action( 'delete_post', 'delete_get_vicuna_calendar_cache' );
add_action( 'update_option_start_of_week', 'delete_get_vicuna_calendar_cache' );
add_action( 'update_option_gmt_offset', 'delete_get_vicuna_calendar_cache' );
add_action( 'update_option_start_of_week', 'delete_get_vicuna_calendar_cache' );

add_action( 'init', 'update_vicuna_options');
add_action( 'admin_menu', 'add_vicuna_options_menu' );

?>
