<?php echo '<?xml version="1.0" encoding="'. get_bloginfo('charset') . '" ?>'; ?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<?php
	if (function_exists('wpj_cut_hindrance')) {
		$lang = wpj_cut_hindrance(get_bloginfo('language'));
	} else {
		$lang = "ja";
	}
?>
<html xmlns="http://www.w3.org/1999/xhtml" lang="<?php echo $lang; ?>" xml:lang="<?php echo $lang; ?>">
<head profile="http://purl.org/net/ns/metaprof">
	<meta http-equiv="Content-Type" content="text/html; charset=<?php bloginfo('charset'); ?>" />
	<meta http-equiv="Content-Script-Type" content="text/javascript" />
	<meta name="generator" content="WordPress <?php bloginfo('version'); ?>" />
	<meta name="author" content="<?php bloginfo('name'); ?>" />
<?php	$feed_type = get_option('vicuna_feed_type');
	$feed_url = get_option('vicuna_feed_url');
	if ( $feed_type && $feed_url ) : ?>
	<link rel="alternate" type="application/<?php echo $feed_type; ?>" href="<?php echo $feed_url; ?>" title="All Entries Feeds" />
<?php	else : ?>
	<link rel="alternate" type="application/rss+xml" href="<?php bloginfo('rss2_url'); ?>" title="RSS 2.0" />
	<link rel="alternate" type="application/atom+xml" href="<?php bloginfo('atom_url'); ?>" title="Atom cite contents" />
<?php	endif; ?>
<?php	if ( !is_home() ) : ?>
	<link rel="start" href="<?php bloginfo('home'); ?>" title="<?php bloginfo('name'); ?> Home" />
<?php	endif; ?>
<?php	if ( $description = get_bloginfo('description') ) : ?>
	<meta name="description" content="<?php bloginfo('description'); ?>" />
<?php	endif; ?>
	<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />
<?php	if ( is_single() || is_page() ) : ?>
	<script type="text/javascript" charset="utf-8" src="<?php echo get_javascript_uri() ?>"></script>
<?php	endif; ?>
<?php wp_head(); ?>
<?php
	$skin = get_option('vicuna_skin');
	$template_url = get_bloginfo('template_url');
	if ($skin) :
?>
	<link rel="stylesheet" type="text/css" href="<?php echo $template_url .'/'. $skin . '/0-import.css'; ?>" />
<?php		if (get_option('vicuna_g_navi_display') == 1) : ?>
	<link rel="stylesheet" type="text/css" href="<?php echo $template_url .'/'. $skin . '/module/mod_gNavi.css'; ?>" />
<?php		endif; ?>
<?php		if (check_widget_display('navi', 'calendar') || check_widget_display('others', 'calendar')) : ?>
	<link rel="stylesheet" type="text/css" href="<?php echo $template_url .'/'. $skin . '/module/mod_calendar.css'; ?>" />
<?php		endif; ?>
<?php		if (get_option('vicuna_eye_catch')) : ?>
	<link rel="stylesheet" type="text/css" href="<?php echo $template_url .'/'. $skin . '/module/mod_eyeCatch-'. get_option('vicuna_eye_catch').'.css'; ?>" />
<?php		endif;
	endif;
?>
