<?php	get_header();
	$layout = get_option('vicuna_single_layout');
	if (!$layout) $layout = 'single';
	if ( is_attachment() ) :
		$older_post = &get_post($GLOBALS['post']->post_parent);
	else :
		$older_post = get_previous_post(false, '');
	endif;
	if ( $layout == 'multi' ) : ?>
	<link rel="stylesheet" type="text/css" href="<?php echo get_skin_uri() . '/module/mod_multiCol-Type'. (get_option('vicuna_3column_type') + 1) .'.css'; ?>" />
<?php	endif; ?>
<?php	if ($older_post) : ?>
	<link rel="prev" href="<?php echo get_permalink($older_post->ID) ?>" title="<?php echo apply_filters('the_title', $older_post->post_title, $older_post) ?>" />
<?php	endif; ?>
<?php	if ( $newer_post = get_next_post(false, '') ) : ?>
	<link rel="next" href="<?php echo get_permalink($newer_post->ID) ?>" title="<?php echo apply_filters('the_title', $newer_post->post_title, $newer_post) ?>" />
<?php	endif; ?>
	<title><?php bloginfo('name'); ?> - <?php the_title(); ?></title>
</head>
<?php	if (have_posts()) : the_post(); ?>
<body class="individual <?php echo $layout; ?>" id="entry<?php the_ID(); ?>">
<div id="header">
	<p class="siteName"><a href="<?php bloginfo('home'); ?>" title="<?php bloginfo('name'); ?> Indexへ戻る"><?php bloginfo('name'); ?></a></p>
<?php		if ( $description = get_bloginfo('description') ) : ?>
	<p class="description"><?php bloginfo('description'); ?></p>
<?php		endif; ?>
<?php		if ( get_option('vicuna_g_navi_display') ) : ?>
	<ul id="globalNavi">
<?php			if ( get_option('vicuna_g_navi_home') ) : ?>
		<li><a href="<?php bloginfo('home'); ?>" title="Home">Home</a></li>
<?php			endif;
			wp_list_pages('sort_column=menu_order&title_li=0&depth=1'); ?>
	</ul>
<?php		endif; ?>
</div>

<div id="content">
	<div id="main">
		<p class="topicPath"><a href="<?php bloginfo('home'); ?>">Home</a> &gt; <?php the_category(' | ') ?> &gt; <span class="current"><?php the_title(); ?></span></p>
		<ul class="flip" id="flip1">
<?php		if ($newer_post) : ?>
		<li class="newer"><a href="<?php echo get_permalink($newer_post->ID) ?>" title="<?php echo apply_filters('the_title', $newer_post->post_title, $newer_post) ?>" rel="nofollow">Newer</a></li>
<?php		endif;
		if ( $older_post ) : ?>
		<li class="older"><a href="<?php echo get_permalink($older_post->ID) ?>" title="<?php echo apply_filters('the_title', $older_post->post_title, $older_post); ?>" rel="nofollow">Older</a></li>
<?php		endif; ?>
		</ul>
		<h1><?php the_title(); ?></h1>
		<div class="entry">
			<ul class="info">
				<li class="date"><?php the_time('Y-m-d (D) G:i') ?></li>
				<li class="category"><?php the_category(' | ') ?><?php /* <MTEntryCategories glue=" | "><a href="<$MTCategoryArchiveLink$>" title="<MTCategoryLabel> Index"><MTCategoryLabel></a></MTEntryCategories> */ ?></li>
				<?php edit_post_link('Edit', '<li class="admin">', '</li>'); ?>
			</ul>
			<div class="textBody">
<?php the_content('Continue reading'); ?>
			</div>

			<ul class="flip" id="flip2">
<?php		if ( $newer_post ) : ?>
				<li class="newer">Newer: <a href="<?php echo get_permalink($newer_post->ID) ?>" title="1つ新しい記事"><?php echo apply_filters('the_title', $newer_post->post_title, $newer_post) ?></a></li>
<?php		endif;
		if ( $older_post ) : ?>
				<li class="older">Older: <a href="<?php echo get_permalink($older_post->ID) ?>" title="1つ古い記事"><?php echo apply_filters('the_title', $older_post->post_title, $older_post) ?></a></li>
<?php		endif; ?>
			</ul>


<?php 		comments_template(); ?>

		</div><!--end entry-->
		<p class="topicPath"><a href="<?php bloginfo('home'); ?>">Home</a> &gt; <?php the_category(' | ') ?> &gt; <span class="current"><?php the_title(); ?></span></p>
	</div><!-- end main-->

<?php		get_sidebar(); ?>

<?php		get_footer(); ?>
<?php	endif; ?>
