# -*- coding: utf-8 -*-

#########################################################################
## - Application Name: Machikane-Red
## - Version: 3.1811
## - Date: 2019-01-04
## - Copyright: (c) 2018-2019 Mitsuhiro Tsuda.
## - License: Machikane-Red (version 3.1811) is released
##            under the GNU General Public License (GPL).
##            See the copyright notice LICENSE.
#########################################################################

import os, datetime

#_prefix = 'mr'  #Machikane Red

# ==============================
# Class
# 2018-11
# ==============================
dbm.define_table('mr_classes',
                #Field('id'),
                Field('mr_title', 'string', default='', label=T('Class title')),
                Field('mr_description', 'text', default='', label=T('Description')),
                Field('mr_target', 'string', default='resource', requires=IS_IN_SET(['undefined','resource','page']), label=T('Table target')),
                Field('mr_order', 'integer', default=1, label=T('Display order')),
                Field('mr_open', 'boolean', default=False, label=T('Open')),
                format='%(mr_title)s'
                )
if dbm(dbm.mr_classes.id>0).count()==0:
    dbm.mr_classes.truncate()
    dbm.mr_classes.insert(mr_title=T('Undefined'),mr_target='undefined')    #1
    dbm.mr_classes.insert(mr_title=T('Page section'),mr_description=T('Page section'),mr_target='page',mr_open=True)    #2
    dbm.mr_classes.insert(mr_title=T('Metadata set'),mr_description=T('Metadata set'),mr_target='resource',mr_open=True)    #3

# Class element
# Title,Description,Author,Date,Place,Rights,etc.
dbm.define_table('mr_class_elements',
                #Field('id'),
                Field('mr_class_id', 'reference mr_classes', default=1, label=T('Class id')),
                Field('mr_definition_name', 'string', default=None, label=T('Element definition name')),
                Field('mr_title', 'string', default='', label=T('Element title')),
                Field('mr_description', 'text', default='', label=T('Description')),
                #Field('mr_search', 'integer', default=1, readable=False, writable=False, label=T('Search group id')),
                Field('mr_order', 'integer', default=1, label=T('Display order')),
                Field('mr_open', 'boolean', default=False, label=T('Open')),
                format=lambda r: '%s:%s' % (dbm.mr_classes[r.mr_class_id].mr_title,r.mr_title)
                )
dbm.mr_class_elements.mr_class_id.requires = IS_IN_DB(dbm
    ,dbm.mr_classes._id
    ,'%(mr_title)s'
    ,orderby=[dbm.mr_classes.mr_order,dbm.mr_classes._id]
    )
if dbm(dbm.mr_class_elements._id>0).count()==0:
    dbm.mr_class_elements.truncate()
    dbm.mr_class_elements.insert(mr_class_id=2,mr_definition_name='title',mr_title=T('Title'),mr_open=True)         #1
    dbm.mr_class_elements.insert(mr_class_id=2,mr_definition_name='description',mr_title=T('Description'),mr_open=True)   #2
    dbm.mr_class_elements.insert(mr_class_id=2,mr_definition_name='date',mr_title=T('Date'),mr_open=True)          #3
    dbm.mr_class_elements.insert(mr_class_id=2,mr_definition_name='creator',mr_title=T('Creator'),mr_open=True)        #4
    dbm.mr_class_elements.insert(mr_class_id=3,mr_definition_name='title',mr_title=T('Title'),mr_open=True)         #5
    dbm.mr_class_elements.insert(mr_class_id=3,mr_definition_name='description',mr_title=T('Description'),mr_open=True)   #6

# ==============================
# Collection
# Grouping of resources
# 2018-11
# ==============================
dbm.define_table('mr_collections',
                #Field('id'),
                Field('mr_parent_id', 'integer', default=1, label=T('Collection parent id')),
                Field('mr_slug', 'string', default='', label=T('Collection slug')),
                Field('mr_title', 'string', default='', label=T('Collection title')),
                Field('mr_description', 'text', default='', label=T('Description')),
                Field('mr_order', 'integer', default=1, label=T('Display order')),
                Field('mr_open', 'boolean', default=False, label=T('Open')),
                format='%(mr_title)s'
                )
if dbm(dbm.mr_collections._id>0).count()==0:
    dbm.mr_collections.truncate()
    dbm.mr_collections.insert(mr_slug='root',mr_title=T('Root'))    #1


# ==============================
# Resource
# a photo, a book, a paper etc.
# 2018-11
# ==============================
dbm.define_table('mr_resources',
                #Field('id'),
                Field('mr_parent_id', 'reference mr_resources', default=1, label=T('Resource parent id')),
                Field('mr_collection_ids', 'list:reference mr_collections', default=None, label=T('Collection ids')),
                #Field('mr_tag_ids', 'list:integer', default=None, label=T('Tag ids')),
                Field('mr_class_id', 'reference mr_classes', default=1, label=T('Class id')),
                Field('mr_slug', 'string', default='', label=T('Resource slug')),
                #Field('mr_title', 'text', default='', label=T('Resource title')),
                Field('mr_summary', 'text', default='', readable=True, writable=False, label=T('Resource summary')),
                Field('mr_order', 'integer', default=1, label=T('Display order')),
                Field('mr_open', 'boolean', default=False, label=T('Open')),
                format=lambda r: '%s' % r.mr_slug if r.mr_slug else '%d' % r._id
                #format='%(id)s'
                )
dbm.mr_resources.mr_parent_id.requires = IS_IN_DB(dbm
    ,dbm.mr_resources
    ,dbm.mr_resources._format
    ,orderby=[dbm.mr_resources.mr_order,dbm.mr_resources._id]
    )
dbm.mr_resources.mr_collection_ids.requires = IS_IN_DB(dbm
    , dbm.mr_collections._id
    ,'%(mr_title)s'
    ,orderby=[dbm.mr_collections.mr_order,dbm.mr_collections.mr_order]
    ,multiple=True
    )
dbm.mr_resources.mr_class_id.requires = IS_IN_DB(dbm
    ,dbm.mr_classes._id
    ,'%(mr_title)s'
    ,orderby=[dbm.mr_classes.mr_order,dbm.mr_classes._id]
    )
if dbm(dbm.mr_resources._id>0).count()==0:
    dbm.mr_resources.truncate()
    dbm.mr_resources.insert(mr_slug='root') #,mr_title=T('Root(undefined)'))    #1


# Resource item
dbm.define_table('mr_resource_items',
                #Field('id'),
                Field('mr_resource_id', 'reference mr_resources', default=1, writable=False, label=T('Resource id')),
                Field('mr_class_element_id', 'reference mr_class_elements', default=1, label=T('Class element id')),
                Field('mr_text', 'text', default='', label=T('Resource document')),
                Field('mr_order', 'integer', default=1, label=T('Display order')),
                Field('mr_open', 'boolean', default=False, label=T('Open'))
                )
dbm.mr_resource_items.mr_resource_id.requires = IS_IN_DB(dbm
    ,dbm.mr_resources
    ,dbm.mr_resources._format
    ,orderby=[dbm.mr_resources.mr_order,dbm.mr_resources._id]
    )
dbm.mr_resource_items.mr_class_element_id.requires = IS_IN_DB(dbm
    ,dbm.mr_class_elements
    ,dbm.mr_class_elements._format
    )


# ==============================
# File group
# 2018-11
# ==============================
#dbm.define_table('mr_groups',
#                #Field('id'),
#                Field('mr_resource_id', 'reference mr_resources', default=1, writable=True, label=T('Resource id')),
#                #Field('mr_resource_ids', 'list:reference mr_resources', default=[1], label=T('Resource ids')), # RESERVED
#
#                Field('mr_identifier', 'string', default='', label=T('Group idenfitier')),
#                Field('mr_title', 'string', default='', label=T('Group title')),
#                Field('mr_description', 'text', default='', label=T('Group description')),
#                Field('mr_license', 'text', default='', label=T('Group license')),
#                Field('mr_note', 'text', default='', label=T('Group note')),
#
#                Field('mr_order', 'integer', default=1, label=T('Display order')),
#                Field('mr_open', 'boolean', default=True, label=T('Open'))
#                format='%(mr_group_title)s'
#                )
#dbm.mr_groups.mr_resource_id.requires = IS_IN_DB(dbm
#    ,dbm.mr_resources
#    ,dbm.mr_resources._format
#    ,orderby=[dbm.mr_resources.mr_order,dbm.mr_resources._id]
#    )


# File
dbm.define_table('mr_files',
                #Field('id'),
                Field('mr_resource_id', 'reference mr_resources', default=1, writable=True, label=T('Resource id')),
                #Field('mr_resource_ids', 'list:reference mr_resources', default=[1], label=T('Resource ids')), # RESERVED
                #Field('mr_group_id', 'reference mr_groups', default=1, label=T('Resource group')), # RESERVED

                Field('mr_identifier', 'string', default='', label=T('File idenfitier')),
                Field('mr_title', 'string', default='', label=T('File title')),
                Field('mr_description', 'text', default='', label=T('File description')),
                Field('mr_license', 'text', default='', label=T('File license')),
                Field('mr_note', 'text', default='', label=T('File note')),

                # 非公開
                Field('mr_original_file', 'upload', readable=True, writable=False, uploadfolder=os.path.normpath(os.path.join(MR_CONF['FILEBASE_PATH'],'uploads')), uploadseparate=True, autodelete=True, label=T('Entry File')),    #アップロードデータ
                Field('mr_original_file_name', 'string', readable=True, writable=False, label=T('Original file name')),
                Field('mr_original_file_format', 'string', readable=False, writable=False, label=T('Original file format')),    #ファイル拡張子（jpg, png, gif, pdf, txt）
                Field('mr_imw', 'integer', readable=False, writable=False, default=0, label=T('Original width')),    #非公開リソース：画像の横サイズ（画素）
                Field('mr_imh', 'integer', readable=False, writable=False, default=0, label=T('Original height')),    #非公開リソース：画像の縦サイズ（画素）

                # 公開
                Field('mr_subfolder', 'string', readable=True, writable=False, default='', label=T('File subfolder')),     #リソース・サブフォルダ (201811 etc.)
                Field('mr_iml', 'string', readable=True, writable=True, label=T('Public file name')),
                Field('mr_imm', 'string', readable=True, writable=True, label=T('Public snap name')),         #中間サイズ画像(640px)
                Field('mr_ims', 'string', readable=True, writable=True, label=T('Public thumbnail name')),    #サムネイル画像(160px)
                Field('mr_imlw', 'integer', readable=True, writable=False, default=0, label=T('L width')),    #画像の横サイズ（画素）
                Field('mr_imlh', 'integer', readable=True, writable=False, default=0, label=T('L height')),   #画像の縦サイズ（画素）
                Field('mr_immw', 'integer', readable=False, writable=False, default=0, label=T('M width')),    #中間サイズ画像の横サイズ（画素）
                Field('mr_immh', 'integer', readable=False, writable=False, default=0, label=T('M height')),   #中間サイズ画像の縦サイズ（画素）
                Field('mr_imsw', 'integer', readable=False, writable=False, default=0, label=T('S width')),    #サムネイル画像の横サイズ（画素）
                Field('mr_imsh', 'integer', readable=False, writable=False, default=0, label=T('S height')),   #サムネイル画像の縦サイズ（画素）

                Field('mr_public_file_format', 'string', default='', readable=True, writable=True, label=T('Public file format')),    #公開ファイルフォーマット

                Field('mr_rotation', 'integer', default=0, readable=False, writable=False, label=T('Rotation')),    #元画像の要回転指示（度）

                Field('mr_editor', 'integer', default=1, readable=True, writable=True, label=T('Editor')),    #編集者

                Field('mr_full', 'text', default='', readable=True, writable=False, label=T('Full')),    #一般検索用

                Field('mr_create_date', 'datetime', readable=True, writable=True, label=T('Entry Date')),    #登録年月日
                Field('mr_update_date', 'datetime', readable=True, writable=True, label=T('Correct Date')),    #更新年月日
                Field('mr_version', 'integer', default=1, readable=True, writable=True, label=T('Version')),    #バーション

                Field('mr_order', 'integer', default=1, label=T('Display order')),
                Field('mr_open', 'boolean', default=True, label=T('Open')),
                format='%(mr_title)s'
                )
dbm.mr_files.mr_resource_id.requires = IS_IN_DB(dbm
    ,dbm.mr_resources
    ,dbm.mr_resources._format
    ,orderby=[dbm.mr_resources.mr_order,dbm.mr_resources._id]
    )
dbm.mr_files.mr_original_file_format.requires = IS_IN_SET([
        'jpg'  #0
        ,'pdf'  #1
        ,'tif'  #2
        ,'bmp'  #3
        ,'png'  #4
    ])
dbm.mr_files.mr_public_file_format.requires = IS_IN_SET([
        'jpg'  #0
        ,'pdf'  #1
        ,'tif'  #2
        ,'jp2'  #3
    ])


# ==========================================
# Page container
# grouping of page-sections (or blog-entry)
# 2018-11
# ==========================================
dbm.define_table('mr_pages',
                #Field('id'),
                Field('mr_slug', 'string', default=None, label=T('Page slug')),
                Field('mr_title', 'text', default='', label=T('Page title')),
                Field('mr_text', 'text', default='', label=T('Page text')),
                Field('mr_order', 'integer', default=1, label=T('Display order')),
                Field('mr_open', 'boolean', default=False, label=T('Open')),
                format=lambda r: '%s' % r.mr_slug if r.mr_slug is not None else '%d' % r._id
                )
if dbm(dbm.mr_pages._id>0).count()==0:
    dbm.mr_pages.truncate()
    dbm.mr_pages.insert(mr_slug=T('welcome'),mr_title=T('Welcome'),mr_open=True)    #1


# Page section (Blog entry)
dbm.define_table('mr_sections',
                #Field('id'),
                Field('mr_page_id', 'reference mr_pages', default=1, label=T('Page id')),
                Field('mr_slug', 'string', default=None, label=T('Blog slug')),
                Field('mr_text', 'text', default='', label=T('Blog text')),
                Field('mr_class_id', 'reference mr_classes', default=1, label=T('Class id')),
                Field('mr_order', 'integer', default=1, label=T('Display order')),
                Field('mr_open', 'boolean', default=False, label=T('Open')),
                format=lambda r: '%s' % r.mr_slug if r.mr_slug is not None else '%d' % r._id
                )
dbm.mr_sections.mr_page_id.requires = IS_IN_DB(dbm
    ,dbm.mr_pages
    ,dbm.mr_pages._format
    )
if dbm(dbm.mr_sections._id>0).count()==0:
    dbm.mr_sections.truncate()
    dbm.mr_sections.insert(mr_page_id=1,mr_slug='welcome',mr_class_id=2,mr_open=True)    #1


# Page section item
dbm.define_table('mr_section_items',
                #Field('id'),
                Field('mr_section_id', 'reference mr_sections', default=1, writable=False, label=T('Page section id')),
                Field('mr_class_element_id', 'reference mr_class_elements', default=1, label=T('Class element id')),
                Field('mr_text', 'text', default='', label=T('Page section document')),
                Field('mr_order', 'integer', default=1, label=T('Display order')),
                Field('mr_open', 'boolean', default=False, label=T('Open'))
                )
dbm.mr_section_items.mr_section_id.requires = IS_IN_DB(dbm
    ,dbm.mr_sections
    ,dbm.mr_sections._format
    ,orderby=[dbm.mr_sections.mr_order,dbm.mr_sections._id]
    )
dbm.mr_section_items.mr_class_element_id.requires = IS_IN_DB(dbm
    ,dbm.mr_class_elements
    ,dbm.mr_class_elements._format
    )
if dbm(dbm.mr_section_items._id>0).count()==0:
    dbm.mr_section_items.truncate()
    dbm.mr_section_items.insert(mr_section_id=1,mr_class_element_id=1,mr_text='ようこそ')  #1
    dbm.mr_section_items.insert(mr_section_id=1,mr_class_element_id=2,mr_text='ようこそ、Machikane-Red へ')  #2
    dbm.mr_section_items.insert(mr_section_id=1,mr_class_element_id=3,mr_text='2018-11-09')  #3
    dbm.mr_section_items.insert(mr_section_id=1,mr_class_element_id=4,mr_text='Developer')  #4


# ==============================
# Annotation
# 2018-11
# ==============================
dbm.define_table('mr_annotes',
                #Field('id'),
                Field('mr_resource_id', 'reference mr_resources', default=1, writable=True, label=T('Resource id')),
                Field('mr_file_id', 'reference mr_files', default=1, writable=True, label=T('File id')),

                Field('mr_slug', 'string', default='', label=T('Annotation slug')),
                Field('mr_text', 'text', default='', label=T('Annotation document')),

                Field('mr_annote_type', 'string', default='rect', label=T('Annotation type')),
                Field('mr_annote_area', 'list:integer', default=[0,0,0,0], label=T('Annotation area')),
                Field('mr_annote_rotation', 'double', default=0.0, label=T('Annotation rotation')),
                Field('mr_annote_data', 'list:integer', default=[0,0,0,0], label=T('Annotation data')),
                Field('mr_annote_color', 'list:integer', default=[0,0,255,60], label=T('Annotation color')),    # Annotation color with alpha

                Field('mr_order', 'integer', default=1, label=T('Display order')),
                Field('mr_open', 'boolean', default=False, label=T('Open'))
                )
dbm.mr_annotes.mr_resource_id.requires = IS_IN_DB(dbm
    ,dbm.mr_resources
    ,dbm.mr_resources._format
    ,orderby=[dbm.mr_resources.mr_order,dbm.mr_resources._id]
    )
dbm.mr_annotes.mr_file_id.requires = IS_IN_DB(dbm
    ,dbm.mr_files
    ,dbm.mr_files._format
    )
dbm.mr_annotes.mr_annote_type.requires = IS_IN_SET([
        'area'  #Segment
        ,'rect' #Annotation
    ])


# ==============================
# File Manager for Expoted files
# 2018-11
# ==============================
dbm.define_table('mr_exports',
                #Field('id'),
                Field('mr_file', 'upload', readable=False, writable=False, uploadfolder=os.path.normpath(os.path.join(MR_CONF['EXPORT_PATH'])), autodelete=True, label=T('Export file')),
                Field('mr_filename', 'string', default='', label=T('File name')),    #ファイル名
                Field('mr_createdate', 'datetime', default=datetime.datetime.now(), label=T('Create date')),    #作成日時
                Field('mr_enabled', 'boolean', default=True, label=T('Enabled'))    #有効判別（無効：False, 有効：True(Default))
                )
