<?php
/**
 * PathConfigure.
 * @package magic.core
 * @subpackage config
 */
/**
 * アプリケーションのクラスパスを解決するインターフェイスです.
 * <p>
 * アプリケーション側のフォルダ構成を変更する場合は、
 * このインターフェイスを実装したクラスを作成してください。
 * </p>
 * @package magic.core
 * @subpackage config
 * @author T.Okumura
 * @version 1.0.0
 */
interface PathConfigure {
    /**
     * Actionクラスのsuffixを取得します.
     * <p>
     * アプリケーション側で共通のsuffixを使用する予定がないのなら、
     * 空文字''を返すように実装してください。<br/>
     * 共通のsuffixがなくても、Actionクラスのパスから取得しようと試みます。
     * </p>
     * @return string Actionクラスのsuffix
     */
    function getActionSuffix();
    /**
     * Actionクラスのフォルダパスを取得します.
     * <p>
     * これは必須です。<br/>
     * デフォルトでは、必然的にアプリケーション側のActionクラスは、
     * 一つのパッケージに集約される事を意味しています。<br/>
     * ただし、実装クラスの記述によっては、
     * Actionクラスのフォルダ構成を複数にする事も可能でしょう。<br/>
     * 必ず最後にDIRECTORY_SEPARATORを含めるようにしてください。
     * </p>
     * @return string Actionクラスのフォルダパス
     */
    function getActionPath();
    /**
     * DAOクラスのsuffixを取得します.
     * <p>
     * アプリケーションがDAOクラスを使用する際には必須です。<br/>
     * フレームワークはこのsuffixを見て、ActionクラスにDAOクラスをインジェクションします。<br/>
     * 統一されたsuffixがなければ、フレームワークがクラスの型を理解できません。<br/>
     * PDOが利用できない環境では、DAOクラスを使用せず、独自の機能を提供する必要があります。
     * </p>
     * @return string DAOクラスのsuffix
     */
    function getDaoSuffix();
    /**
     * DAOクラスのフォルダパスを取得します.
     * <p>
     * これは必須ではありません。<br/>
     * アプリケーションでDAOクラスを使用しない場合は省略できます。<br/>
     * DAOクラスを使用する場合は、必ず最後にDIRECTORY_SEPARATORを含めるようにしてください。
     * </p>
     * @return string DAOクラスのフォルダパス
     */
    function getDaoPath();
    /**
     * DTOクラスのsuffixを取得します.
     * <p>
     * アプリケーションがDTOクラスを使用する際には必須です。<br/>
     * フレームワークはこのsuffixを見て、ActionクラスにDAOクラスをインジェクションします。<br/>
     * 統一されたsuffixがなければ、フレームワークがクラスの型を理解できません。
     * </p>
     * @return string DTOクラスのsuffix
     */
    function getDtoSuffix();
    /**
     * DTOクラスのフォルダパスを取得します.
     * <p>
     * これは必須ではありません。<br/>
     * アプリケーションでDTOクラスを使用しない場合は省略できます。<br/>
     * DTOクラスを使用する場合は、必ず最後にDIRECTORY_SEPARATORを含めるようにしてください。
     * </p>
     * @return string DTOクラスのフォルダパス
     */
    function getDtoPath();
    /**
     * Viewクラスのsuffixを取得します.
     * <p>
     * アプリケーション側で共通のsuffixを使用する予定がないのなら、
     * 空文字''を返すように実装してください。
     * 共通のsuffixがなくても、Viewクラスのパスから取得しようと試みます。
     * </p>
     * @return string Viewクラスのsuffix
     */
    function getViewSuffix();
    /**
     * Viewクラスのフォルダパスを取得します.
     * <p>
     * これは必須です。<br/>
     * デフォルトでは、必然的にアプリケーション側のViewクラスは、
     * 一つのパッケージに集約される事を意味しています。<br/>
     * ただし、実装クラスのやり方によっては、
     * Viewクラスのフォルダ構成を複数にする事も可能でしょう。<br/>
     * 必ず最後にDIRECTORY_SEPARATORを含めるようにしてください。
     * </p>
     * @return string Viewクラスのフォルダパス
     */
    function getViewPath();
    /**
     * HTMLファイルのsuffixを取得します.
     * <p>
     * 通常はhtmlを設定しますが、アプリケーションによっては、
     * htmやshtmlかも知れません。<br/>
     * また、複数の種類を使い分ける必要があるかも知れません。
     * </p>
     * @return string HTMLファイルのsuffix
     */
    function getHtmlSuffix();
    /**
     * HTMLファイルのフォルダパスを取得します.
     * <p>
     * これは必須です。<br/>
     * デフォルトでは、必然的にアプリケーション側のHTMLファイルは、
     * 一つのフォルダに集約される事を意味しています。<br/>
     * ただし、実装クラスのやり方によっては、
     * HTMLファイルのフォルダ構成を複数にする事も可能でしょう。<br/>
     * 必ず最後にDIRECTORY_SEPARATORを含めるようにしてください。
     * </p>
     * @return string HTMLファイルのフォルダパス
     */
    function getHtmlPath();
    /**
     * デフォルトのメッセージファイル名を取得します.
     * <p>
     * フレームワークでは、ロケールに基づいてファイル名が決定されます。
     * 例えば、ブラウザのロケールが「ja」の場合、ここで指定されたファイル名に、
     * 「_ja」を付加したファイル名を同一ディレクトリで探し、「en」なら「_en」を探します。
     * いずれのファイルも見つからなければ、ここで取得した名前で探しに行き、
     * それでもなければexceptionをスローします。<br/>
     * 適切なメッセージ出力のためには、アプリケーションは少なくとも一つの
     * メッセージファイルを用意する必要があります。
     * </p>
     * <p>
     * メッセージファイルの記述方法は、{@link SystemMessage}クラスを参考にしてください。<br/>
     * また、メッセージがどのように取得され、使用されているかは、{@link MessageBehavior}クラスを参照してください。<br/>
     * ロケールに関する詳細は、{@link LocaleProvider}クラスを参照してください。
     * </p>
     * @return string デフォルトのメッセージファイル名
     * @see SystemMessage
     * @see MessageBehavior
     * @see LocaleProvider
     */
    function getDefaultMessageFileName();
    /**
     * メッセージファイルのフォルダパスを取得します.
     * <p>
     * これは必須ではありません。<br/>
     * アプリケーションでメッセージファイルを使用しない場合は省略できます。<br/>
     * メッセージファイルを使用する場合は、必ず最後にDIRECTORY_SEPARATORを含めるようにしてください。
     * </p>
     * @return string メッセージファイルのフォルダパス
     */
    function getMessagePath();
}
// EOF.