<?php
/**
 * DataSourceConfigureImpl.
 * @package magic.core
 * @subpackage config.impl
 */
/**
 * データソースのデフォルトの実装クラスです.
 * <p>
 * このクラスは必要な時に{@link Controller}によってロードされます。
 * </p>
 * @package magic.core
 * @subpackage config.impl
 * @author T.Okumura
 * @version 1.0.0
 */
final class DataSourceConfigureImpl implements DataSourceConfigure {
    /**
     * コンストラクタ.
     */
    public function __construct() {
    }
    /**
     * デフォルトでは、MySQLのtestデータベースを返します.
     * <p>
     * Localhostのデフォルトポート(3306)を指定しています。
     * </p>
     * @see DataSourceConfigureImpl::getDsn()
     */
    public function getDsn() {
        return 'mysql:dbname=test;host=localhost;port=3306';
    }
    /**
     * デフォルトでは、rootユーザーを返します.
     * @see DataSourceConfigureImpl::getUserName()
     */
    public function getUserName() {
        return 'root';
    }
    /**
     * デフォルトでは、空のパスワード文字列を返します.
     * @see DataSourceConfigureImpl::getPassword()
     */
    public function getPassword() {
        return '';
    }
    /**
     * デフォルトでは、空の配列を返します.
     * @see DataSourceConfigureImpl::getOptions()
     */
    public function getOptions() {
        return array();
    }
}
// EOF.