<?php
/**
 * Dao.
 * @package magic.core
 * @subpackage helper.base
 */
/**
 * DAOの基底クラスです.
 * <p>
 * アプリケーションでDAOクラスを使用する場合は、
 * 必ずこのクラスを継承して作成してください。<br/>
 * データベースの接続にはPDOを使用しています。
 * PDOが利用できない環境では、独自のデータベースアクセスクラスを作成してください。
 * </p>
 * @package magic.core
 * @subpackage helper.base
 * @author T.Okumura
 * @version 1.0.0
 */
class Dao {
    /**
     * PDOオブジェクトを保持します.
     * @var PDO
     */
    protected $pdo = NULL;
    /**
     * コンストラクタ.
     */
    public function __construct() {
    }
    /**
     * データベースに接続します.
     * <p>
     * このファンクションはオーバーライドできません。
     * </p>
     * @param DataSourceConfigure $ds データソース設定クラス
     * @throws PDOException 接続に失敗した場合に、PDOによってスローされる例外
     * @final
     */
    public final function initialize(DataSourceConfigure $ds) {
        $this->pdo = new PDO($ds->getDsn(), $ds->getUserName(), $ds->getPassword(), $ds->getOptions());
    }
}
// EOF