<?php
/**
 * LowerSnakeCase.
 * @package magic.core
 * @subpackage helper.naming.impl
 */
/**
 * 小文字のスネークケースクラスです.
 * @package magic.core
 * @subpackage helper.naming.impl
 * @author T.Okumura
 * @version 1.0.0
 * @final
 */
final class LowerSnakeCase implements NamingType {
    /**
     * コンストラクタ.
     */
    public function __construct() {
    }
    /**
     * 小文字のスネークケースに変換された文字列を取得します.
     * @see NamingType::apply()
     */
    public function apply($text) {
        $text = strstr($text, '_') === FALSE ? substr(preg_replace('/([A-Z])/', '_${1}', ucfirst($text)), 1) : $text;
        return strtolower($text);
    }
}
// EOF.