<?php
/**
 * DaoClassLoader.
 * @package magic.core
 * @subpackage internal.loader
 */
/**
 * DAOクラスのローダーです.
 * <p>
 * DAOクラスは、データベースを使用しなければ必要ありません。<br/>
 * アプリケーション側でDAOクラスを使用しないのなら、
 * これは単純に無視されます。
 * </p>
 * @package magic.core
 * @subpackage internal.loader
 * @author T.Okumura
 * @version 1.0.0
 * @final
 */
final class DaoClassLoader {
    /**
     * コンストラクタ.
     */
    private function __construct() {
    }
    /**
     * DAOクラスをロードします.
     * <p>
     * アプリケーションでDAOクラスを使用しない場合はコールされません。
     * </p>
     * @param string $className ロードするクラス名
     * @param NameConfigure $name 命名規則設定クラス
     * @param PathConfigure $path パス設定クラス
     * @return Dao Daoクラスを継承したクラス
     * @throws MagicException クラスがロードできなかった時
     * @static
     */
    public static function load($className, NameConfigure $name, PathConfigure $path) {
        $classPath = $path->getDaoPath();
        $classFile = $name->getPhpFileNamingType()->apply($className) . '.php';
        if (!@include_once $classPath . $classFile) {
            throw new MagicException(MessageBehavior::getMessage('SYS001', $classPath . $classFile));
        }
        $className = $name->getClassNamingType()->apply($className);
        if (!class_exists($className, FALSE)) {
            throw new MagicException(MessageBehavior::getMessage('SYS004', $className));
        }
        $class = new $className();
        if ($class instanceof Dao) {
            return $class;
        }
        throw new MagicException(MessageBehavior::getMessage('SYS002', array('Dao', $className)));
    }
}
// EOF.
