<?php
/**
 * ServerUtil.
 * @package magic.core
 * @subpackage util
 */
/**
 * リクエストから取得したサーバー情報を提供するクラスです.
 * <p>
 * <var>$_SERVER</var>に対する操作と、その他の情報を提供します。
 * </p>
 * @package magic.core
 * @subpackage util
 * @author T.Okumura
 * @version 1.0.0
 * @final
 */
final class ServerUtil {
    /**
     * コンストラクタ.
     */
    private function __construct() {
    }
    /**
     * <var>$_SERVER</var>から値を取得します.
     * @param string $key 取得する値のキー
     * @return mixed 取得できた場合はその値、できなければFALSE
     * @static
     */
    public static function get($key) {
        return array_key_exists($key, $_SERVER) ? $_SERVER[$key] : FALSE;
    }
    /**
     * すべての<var>$_SERVER</var>を取得します.
     * <p>
     * 返されるのは<var>$_SERVER</var>のコピーです。<br/>
     * これによって返された配列に変更を加えても、元の<var>$_SERVER</var>の内容は変更されない事に注意してください。
     * </p>
     * @return array コピーされた<var>$_SERVER</var>の配列
     * @static
     */
    public static function getAll() {
        $copy = $_SERVER;
        return $copy;
    }
    /**
     * スキームを取得します.
     * @return string スキーム(httpまたはhttps)
     * @static
     */
    public static function getScheme() {
        return self::get('HTTPS') === 'on' ? 'https' : 'http';
    }
    /**
     * ホスト名を取得します.
     * <p>
     * 各スキームのデフォルトポートが使用されている場合はホスト名のみを返します。<br/>
     * 特別なポートが指定されている場合は、ポート番号も併せて返されます。
     * </p>
     * @return string ホスト名
     * @static
     */
    public static function getHttpHost() {
        if ($host = self::get('HTTP_HOST')) {
            return $host;
        }
        $scheme = self::getScheme();
        $name = self::get('SERVER_NAME');
        $port = self::get('SERVER_PORT');
        if (($scheme === 'http' && $port == 80) || ($scheme === 'https' && $port == 443)) {
            return $name;
        }
        return $name . ':' . $port;
    }
    /**
     * スキームとホスト名を連結した文字列を取得します.
     * @return string スキームとホスト名を連結した文字列
     * @static
     */
    public static function getBaseUrl() {
        return self::getScheme() . '://' . self::getHttpHost();
    }
}
// EOF.