#! ruby -Ke
#
# $Id: margarine.rb,v 1.1.1.1 2003/04/28 11:51:57 nisi Exp $

require "chasen"
require "mysql"

class Margarine

	def initialize(db_server,db_user,db_pass,db_name,margname)
		@marg_name   = margname
		@marg_nick   = margname
		@user_name   = ''
		@mydb = Mysql.new(db_server,db_user,db_pass,db_name)
	end

	def set_marg(margname)
		@marg_name = margname
	end
	
	def set_marg_nick(margnick)
		@marg_nick = margnick
	end

	def set_user(username)
		@user_name = username
	end

	def margname()
		@marg_name
	end

	def margnick()
		@marg_nick
	end

	def username()
		@user_name
	end
	
	def put_message(message,regflg=nil)
		if message or message != "" then
			words = analysis_message(message,regflg)
			if !regflg and words then
				if words.size >= 3 then
					(words.size - 2).times { |i|
						@mydb.query("UPDATE marg_#{@marg_name}_rl SET w_w = w_w + 1 WHERE st_w = #{words[i]} AND mid_w = #{words[i+1]} AND end_w = #{words[i+2]} ;")
						@mydb.query("INSERT INTO marg_#{@marg_name}_rl(st_w,mid_w,end_w,w_w) VALUES(#{words[i]},#{words[i+1]},#{words[i+2]},1) ;") if @mydb.affected_rows() <= 0 }
				end
			end
		end
	end

	def analysis_message(message,regflg=nil)
		Chasen.getopt( '-j', '-F%m,%y,%M,%Y,%U(%P1)\n')

		chka = Array.new
		message.gsub!(/[\s]+/,' ')
		messa = message.split(/[0-9A-Za-z_ ]+/)
		message.scan(/[0-9A-Za-z_ ]+/) do |ts|
			tss = Array.new
			ts.split(/[ ]/).each do |tsa|
				if tsa != '' then
					if !regflg then
						@mydb.query("UPDATE marg_#{@marg_name}_words SET w_w = w_w + 1 WHERE str_m1 = '#{tsa}' AND str_y1 = '#{tsa}' AND str_m2 = '#{tsa}' AND str_y2 = '#{tsa}' AND str_p = 'ñ' ;")
						@mydb.query("INSERT INTO marg_#{@marg_name}_words(str_m1,str_y1,str_m2,str_y2,str_p,w_w) VALUES('#{tsa}','#{tsa}','#{tsa}','#{tsa}','ñ',1) ;") if @mydb.affected_rows() <= 0
					end

					@mydb.query("SELECT tno FROM marg_#{@marg_name}_words WHERE str_m1 = '#{tsa}' AND str_y1 = '#{tsa}' AND str_m2 = '#{tsa}' AND str_y2 = '#{tsa}' AND str_p = 'ñ' ;").each_hash do |myRw|
						if myRw["tno"] then
							tss.push(myRw["tno"].to_i)
							add_theme(myRw["tno"].to_i)
						else
							tss.push(0)
						end
					end

				end
			end
			chka.push(tss)
		end
		
		ret = [0]
		ri = 0

		if messa[0] then
			messa.each do |messtm|
				Chasen.sparse(messtm).each do |lcha|
					lcha.chomp!
					break if (lcha == 'EOS' or lcha == '')
					anlar = lcha.split(",")
					if !regflg then
						@mydb.query("UPDATE marg_#{@marg_name}_words SET w_w = w_w + 1 WHERE str_m1 = '#{anlar[0]}' AND str_y1 = '#{anlar[1]}' AND str_m2 = '#{anlar[2]}' AND str_y2 = '#{anlar[3]}' AND str_p = '#{anlar[4]}' ;")
						@mydb.query("INSERT INTO marg_#{@marg_name}_words(str_m1,str_y1,str_m2,str_y2,str_p,w_w) VALUES('" + lcha.gsub(",","','") + "',1) ;") if @mydb.affected_rows() <= 0
					end
					@mydb.query("SELECT tno FROM marg_#{@marg_name}_words WHERE str_m1 = '#{anlar[0]}' AND str_y1 = '#{anlar[1]}' AND str_m2 = '#{anlar[2]}' AND str_y2 = '#{anlar[3]}' AND str_p = '#{anlar[4]}' ;").each_hash do |myRw|
						if myRw["tno"] then
							ret.push(myRw["tno"].to_i)
							add_theme(myRw["tno"].to_i) if (anlar[4] == "̾" or anlar[4] == "ư" or anlar[4] == "ư" )
						else
							ret.push(0)
						end
					end
				end
				
				if chka[ri] then
					chka[ri].each {|chtm| ret.push(chtm) }
				end
				ri += 1
			end
		else
			if chka[0] then
				chka[0].each {|chtm| ret.push(chtm) }
			end
		end

		ret.push(0)
	end

	def get_message(messmode,pct=nil)
		pctp = 50
		if pct then
			pct = pct.to_i
			pctp = pct if (pct >= 0 and pct <= 100)
		else
			tmpa = get_etc_config('lget')
			case (Time.now.to_i - tmpa[0].to_i)
			when 30..59
				pctp = 90
			when 20..29
				pctp = 80
			when 10..19
				pctp = 70
			when 5..9
				pctp = 60
			when 0..4
				pctp = 0
			else
				pctp = 95
			end
		end
		return('') if !((rand(100)+1) <= pctp )
		
		if pct then # ơ޼pct꤬ľ10secʤ300sec
			tm = get_theme(10)
		else
			tm = get_theme(300)
		end

		set_etc_config('lget',Time.now.to_i,2)

		if rand(100) > 60 then
			@mydb.query("SELECT str_y1,str_y2 FROM marg_#{@marg_name}_words WHERE tno = #{tm} ;").each_hash do |tmRw|
				tmstr = @mydb.query("SELECT tno FROM marg_#{@marg_name}_words WHERE str_y1 LIKE '%#{tmRw['str_y1']}%' OR str_y2 LIKE '%#{tmRw['str_y2']}%' ;")
				tmstr.field_seek(rand(tmstr.num_rows)+1)
				tm = tmstr.fetch_hash["tno"].to_i
			end
		end

		# messmode 0ǥå1ʾǲ򤤤ˤ㡦

		reta = Array.new
		tl = 0
		@mydb.query("SELECT sum(w_w) AS ct FROM marg_#{@marg_name}_rl WHERE mid_w = #{tm} ;").each_hash { |tmRw|
			tl = tmRw["ct"].to_i }
		@mydb.query("SELECT st_w,end_w,w_w FROM marg_#{@marg_name}_rl WHERE mid_w = #{tm} ;").each_hash do |tmRw|
			reta[0..2] = [ tmRw["st_w"].to_i, tm, tmRw["end_w"].to_i ]
			break if rand(tl) <= tmRw["w_w"].to_i
			tl = tl - tmRw["w_w"].to_i
		end

		while reta[0] != 0
			@mydb.query("SELECT sum(w_w) AS ct FROM marg_#{@marg_name}_rl WHERE mid_w = #{reta[0]} AND end_w = #{reta[1]} ;").each_hash { |tmRw|
				tl = tmRw["ct"].to_i }
			@mydb.query("SELECT st_w,w_w FROM marg_#{@marg_name}_rl WHERE mid_w = #{reta[0]} AND end_w = #{reta[1]} ;").each_hash do |tmRw|
				if rand(tl) <= tmRw["w_w"].to_i
					reta.unshift(tmRw["st_w"].to_i)
					break
				else
					tl = tl - tmRw["w_w"].to_i
				end
			end
		end

		while reta[-1] != 0
			@mydb.query("SELECT sum(w_w) AS ct FROM marg_#{@marg_name}_rl WHERE st_w = #{reta[-2]} AND mid_w = #{reta[-1]} ;").each_hash { |tmRw|
				tl = tmRw["ct"].to_i }
			@mydb.query("SELECT end_w,w_w FROM marg_#{@marg_name}_rl WHERE st_w = #{reta[-2]} AND mid_w = #{reta[-1]} ;").each_hash do |tmRw|
				if rand(tl) <= tmRw["w_w"].to_i
					reta.push(tmRw["end_w"].to_i)
					break
				else
					tl = tl - tmRw["w_w"].to_i
				end
			end
		end

		ret = ""
		reta.each {|sel|
			@mydb.query("SELECT str_m1,str_p FROM marg_#{@marg_name}_words WHERE tno = #{sel} ;").each_hash { |tmRw|
				tmRw["str_p"] == "ñ" ? ret = ret + " " + tmRw["str_m1"] : ret = ret + tmRw["str_m1"] } }

		ret
	end
	
	def add_theme(tno)
		nowtime = Time.now.to_i
		@mydb.query("INSERT INTO marg_#{@marg_name}_tm(di_date,v_w) VALUES(#{nowtime},#{tno}) ;")
	end

	def get_theme(etime=300)
		tvc = 0
		etime = Time.now.to_i - etime
		@mydb.query("SELECT count(v_w) AS vc FROM marg_#{@marg_name}_tm WHERE di_date >= #{etime} ;").each_hash {|tmRw|
			tvc = tmRw["vc"].to_i }
		@mydb.query("SELECT v_w,count(v_w) AS vc FROM marg_#{@marg_name}_tm WHERE di_date >= #{etime} GROUP BY v_w ORDER BY vc DESC ;").each_hash {|tmRw|
			return(tmRw["v_w"].to_i) if rand(tvc) < tmRw["vc"].to_i
			tvc -= tmRw["vc"].to_i }

		# ơޤߤʤ
		@mydb.query("SELECT MAX(tno) AS vc FROM marg_#{@marg_name}_words ;").each_hash {|tmRw|
			tvc = tmRw["vc"].to_i }
		rand(tvc) + 1

		# οǲǡ祤Ȥɤ衩
	end

	def add_marg_nick(nickname)
	# ޡ˥å͡Ͽ
		set_etc_config('nick',nickname,1)
	end

	def remove_marg_nick(nickname)
	# ˥å͡
		set_etc_config('nick',nickname,0)
	end

	def set_etc_config(param,val,act)
	# ѥ顼᡼Х塼åȤ
		case act
		when 0 # DELITEΥѥ᡼ͤΥåȤ
			@mydb.query("DELETE FROM marg_#{@marg_name}_reg WHERE reg_pro = '#{param}' AND reg_val = '#{val}' ;")
		when 1 # INSERTȤˤɲ
			@mydb.query("INSERT INTO marg_#{@marg_name}_reg(reg_pro,reg_val) VALUES('#{param}','#{val}') ;")
		when 2 # UPDATEѥ᡼ͤ񤭴(ALL)
			@mydb.query("UPDATE marg_#{@marg_name}_reg SET reg_val = '#{val}' WHERE reg_pro = '#{param}' ;")
			@mydb.query("INSERT INTO marg_#{@marg_name}_reg(reg_pro,reg_val) VALUES('#{param}','#{val}') ;") if @mydb.affected_rows() <= 0
		when 3 # DELITEѥ᡼ͤ(ALL)
			@mydb.query("DELETE FROM marg_#{@marg_name}_reg WHERE reg_pro = '#{param}' ;")
		end
	end
	
	def get_etc_config(param)
	# 
		ret = Array.new
		@mydb.query("SELECT reg_val FROM marg_#{@marg_name}_reg WHERE reg_pro = '#{param}' ;").each_hash {|myRw|
			ret.push(myRw["reg_val"]) }
		ret
	end
	
	def marg?(margname)
	# Υޡ¸ߤ뤫ɤ¸ߤtrueʤfalse
		ret = false
		@mydb.list_tables.each do |db|
			ret = true if db =~ /^marg_#{margname}_words$/
		end
		ret
	end
	
	def marg_list()
	# ¸ߤޡΥꥹȤ֤
		ret = Array.new
		@mydb.list_tables.each do |db|
			if db =~ /^marg_(.+)_words$/ then
				ret.push($&[5..-7])
			end
		end
		ret
	end
	
	def get_infostr(margname=nil)
	# ɽѤξʸ
		margname = @marg_name if !margname
		ret = "[ " + margname + " ]\n"
		ret = ret + " nick        :"
 		@mydb.query("SELECT reg_val FROM marg_#{margname}_reg WHERE reg_pro = 'nick' ;").each_hash {|myRw|
			ret = ret + myRw["reg_val"].to_s + "," }
		ret = ret.chop + "\n"
 		@mydb.query("SELECT count(*) AS ct FROM marg_#{margname}_words ;").each_hash {|myRw|
			ret = ret + " words       :" + myRw["ct"] + "\n" if myRw["ct"] }
 		@mydb.query("SELECT sum(w_w) AS ct FROM marg_#{margname}_words ;").each_hash {|myRw|
			ret = ret + " -words-s    :" + myRw["ct"] + "\n" if myRw["ct"] }
 		@mydb.query("SELECT count(*) AS ct FROM marg_#{margname}_rl ;").each_hash {|myRw|
			ret = ret + " relation    :" + myRw["ct"] + "\n" if myRw["ct"] }
 		@mydb.query("SELECT sum(w_w) AS ct FROM marg_#{margname}_rl ;").each_hash {|myRw|
			ret = ret + " -relation-s :" + myRw["ct"] + "\n" if myRw["ct"] }
		ret = ret + "\n"
	end

	def setup_marg(action=nil)
	# ޡΥåȥåסʽ㤤ޤ
		if marg?(@marg_name) then
			@mydb.query("DROP TABLE marg_#{@marg_name}_words ;")
			@mydb.query("DROP TABLE marg_#{@marg_name}_rl ;")
			@mydb.query("DROP TABLE marg_#{@marg_name}_tm ;")
			@mydb.query("DROP TABLE marg_#{@marg_name}_reg ;")
		end

		if action != "D" then
			@mydb.query("CREATE TABLE marg_#{@marg_name}_words(tno INT NOT NULL AUTO_INCREMENT PRIMARY KEY,str_m1 VARCHAR(255),str_y1 VARCHAR(255),str_m2 VARCHAR(255),str_y2 VARCHAR(255),str_p VARCHAR(255),w_w INT );")
			@mydb.query("CREATE TABLE marg_#{@marg_name}_rl(tno INT NOT NULL AUTO_INCREMENT PRIMARY KEY, st_w INT, mid_w INT, end_w INT,w_w INT);")
			@mydb.query("CREATE TABLE marg_#{@marg_name}_tm(tno INT NOT NULL AUTO_INCREMENT PRIMARY KEY, di_date INT,v_w INT);")
			@mydb.query("CREATE TABLE marg_#{@marg_name}_reg(tno INT NOT NULL AUTO_INCREMENT PRIMARY KEY,reg_pro VARCHAR(255),reg_val VARCHAR(255));")

			add_marg_nick(@marg_name)
		end

	end

end


