/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.ui.editors;

import jp.sf.maskat.ui.MaskatUIPlugin;
import jp.sf.maskat.ui.Messages;
import jp.sf.maskat.ui.editors.layout.LayoutGraphicalEditor;
import jp.sf.maskat.ui.editors.preview.LayoutPreviewBrowser;
import jp.sf.maskat.ui.editors.xml.MaskatXMLEditor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;

public class MaskatEditor
extends MultiPageEditorPart
implements ISelectionListener,
IResourceChangeListener,
ITabbedPropertySheetPageContributor {
    public static final String EDITOR_ID = "jp.sf.maskat.ui.maskatEditor";
    private LayoutGraphicalEditor graphicalEditor;
    private MaskatXMLEditor xmlEditor;
    private LayoutPreviewBrowser browser;

    protected void createPages() {
        this.createLayoutGraphicalEditorPage();
        this.createLayoutXMLPage();
        this.createPreviewPage();
    }

    private void createLayoutGraphicalEditorPage() {
        try {
            this.graphicalEditor = new LayoutGraphicalEditor();
            int index = this.addPage((IEditorPart)this.graphicalEditor, this.getEditorInput());
            this.setPageText(index, Messages.getString("editor.layout.tabname"));
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)Messages.getString("editor.msg.error.title"), (String)Messages.getString("editor.msg.error.createlayout"), (IStatus)e.getStatus());
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)Messages.getString("editor.msg.error.title"), (String)Messages.getString("editor.msg.error.invalidlayout"));
            MaskatUIPlugin.log((IStatus)new Status(4, "jp.sf.maskat.ui", 4, e.getMessage() == null ? e.getClass().getName() : e.getMessage(), (Throwable)e));
        }
    }

    private void createLayoutXMLPage() {
        try {
            this.xmlEditor = new MaskatXMLEditor();
            int index = this.addPage((IEditorPart)this.xmlEditor, this.getEditorInput());
            this.setPageText(index, Messages.getString("editor.source.tabname"));
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)Messages.getString("editor.msg.error.title"), (String)Messages.getString("editor.msg.error.createsource"), (IStatus)e.getStatus());
        }
    }

    private void createPreviewPage() {
        try {
            this.browser = new LayoutPreviewBrowser();
            int index = this.addPage((IEditorPart)this.browser, this.getEditorInput());
            this.setPageText(index, Messages.getString("editor.preview.tabname"));
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)Messages.getString("editor.msg.error.title"), (String)Messages.getString("editor.msg.error.createpreview"), (IStatus)e.getStatus());
        }
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this);
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        IEditorPart editor = this.getActiveEditor();
        if (editor != null) {
            if (editor == this.browser) {
                this.graphicalEditor.doSave(monitor);
                this.browser.setFocus();
            } else {
                editor.doSave(monitor);
            }
            if (editor == this.graphicalEditor) {
                this.graphicalEditor.setFocus();
            }
        }
    }

    public void doSaveAs() {
        IEditorPart editor = this.getActiveEditor();
        if (editor != null) {
            editor.doSaveAs();
        }
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (!(editorInput instanceof IFileEditorInput)) {
            throw new PartInitException(Messages.getString("editor.msg.error.invalidinput"));
        }
        super.init(site, editorInput);
        this.setPartName(editorInput.getName());
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        site.getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
    }

    public boolean isSaveAsAllowed() {
        IEditorPart editor = this.getActiveEditor();
        if (editor != null) {
            return editor.isSaveAsAllowed();
        }
        return false;
    }

    protected void pageChange(int newPageIndex) {
        int index = this.getDirtyPageIndex();
        if (index != -1 && index != newPageIndex) {
            this.setActivePage(index);
            if (MessageDialog.openConfirm((Shell)this.getSite().getShell(), (String)Messages.getString("editor.msg.confirm.save.title"), (String)Messages.getString("editor.msg.confirm.save.message"))) {
                this.getEditor(index).doSave(null);
                this.setActivePage(newPageIndex);
            }
        } else {
            super.pageChange(newPageIndex);
        }
        this.setFocus();
    }

    private int getDirtyPageIndex() {
        int i = 0;
        while (i < this.getPageCount()) {
            if (this.getEditor(i).isDirty()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void resourceChanged(final IResourceChangeEvent event) {
        final IFile file = ((FileEditorInput)this.getEditorInput()).getFile();
        if (event.getResource() instanceof IProject && event.getType() == 2) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    IWorkbenchPage[] pages = MaskatEditor.this.getSite().getWorkbenchWindow().getPages();
                    int i = 0;
                    while (i < pages.length) {
                        if (file.getProject().equals((Object)event.getResource())) {
                            IEditorPart editorPart = pages[i].findEditor(MaskatEditor.this.getEditorInput());
                            pages[i].closeEditor(editorPart, true);
                        }
                        ++i;
                    }
                }
            });
        } else {
            IResourceDelta delta = event.getDelta();
            if (delta != null) {
                delta = delta.findMember(file.getFullPath());
            }
            if (delta != null && delta.getKind() == 2) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        IWorkbenchPage[] pages = MaskatEditor.this.getSite().getWorkbenchWindow().getPages();
                        int i = 0;
                        while (i < pages.length) {
                            IEditorPart editorPart = pages[i].findEditor(MaskatEditor.this.getEditorInput());
                            pages[i].closeEditor(editorPart, true);
                            ++i;
                        }
                    }
                });
            }
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (((Object)((Object)this)).equals(part) && this.getActiveEditor() == this.graphicalEditor) {
            this.graphicalEditor.selectionChanged((IWorkbenchPart)this.graphicalEditor, selection);
        }
    }

    public String getContributorId() {
        return "jp.sf.maskat.ui.layoutGraphicalEditor";
    }
}

