/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.ui.editors.layout;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import jp.sf.maskat.core.betwixt.MaskatBeanIO;
import jp.sf.maskat.core.event.Component;
import jp.sf.maskat.core.event.Event;
import jp.sf.maskat.core.event.EventDef;
import jp.sf.maskat.core.layout.Layout;
import jp.sf.maskat.core.layout.LayoutDef;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class MaskatResources {
    private LayoutDef layoutDef = null;
    private EventDef eventDef;
    private IFile layoutXMLFile;
    private IFile eventXMLFile;

    MaskatResources(IFile layoutXMLFile) {
        this.layoutXMLFile = layoutXMLFile;
        IContainer folder = layoutXMLFile.getParent();
        String eventXMLFileName = String.valueOf(layoutXMLFile.getLocation().removeFileExtension().lastSegment()) + "_e.xml";
        this.eventXMLFile = folder.getFile((IPath)new Path(eventXMLFileName));
    }

    public IFile getLayoutXMLFile() {
        return this.layoutXMLFile;
    }

    public IFile getEventXMLFile() {
        return this.eventXMLFile;
    }

    Layout getLayout() {
        Layout[] layouts = this.layoutDef.getLayouts();
        return layouts.length > 0 ? layouts[0] : null;
    }

    public void load() throws Exception {
        this.loadLayout();
        this.loadEvent();
        this.connect();
    }

    void connect() {
        this.layoutDef.setEventDef(this.eventDef);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void loadLayout() throws Exception {
        InputStream in = null;
        try {
            if (this.layoutXMLFile.exists()) {
                in = this.layoutXMLFile.getContents();
                this.layoutDef = MaskatBeanIO.readLayoutDef((InputStream)in);
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        IOUtils.closeQuietly((InputStream)in);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void loadEvent() throws Exception {
        this.eventDef = new EventDef();
        InputStream in = null;
        try {
            this.eventXMLFile.refreshLocal(1, null);
            if (this.eventXMLFile.exists()) {
                in = this.eventXMLFile.getContents();
                this.eventDef = MaskatBeanIO.readEventDef((InputStream)in);
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        IOUtils.closeQuietly((InputStream)in);
    }

    public void save() throws Exception {
        this.writeLayout();
        this.writeEvent();
    }

    private void writeLayout() throws Exception {
        String output = MaskatBeanIO.writeLayoutDef((LayoutDef)this.layoutDef);
        byte[] bytes = output.getBytes("UTF-8");
        this.layoutXMLFile.setContents((InputStream)new ByteArrayInputStream(bytes), false, false, null);
    }

    private void writeEvent() throws Exception {
        if (this.eventDef == null) {
            return;
        }
        MaskatResources.marshallObj(this.eventDef, this.eventXMLFile, null);
        this.eventDef.prepareEvent();
    }

    public static void clearBlankComponent(EventDef eventDef) {
        ArrayList<Component> compsToDel = new ArrayList<Component>();
        Component[] components = eventDef.getAllComponents();
        int i = 0;
        while (i < components.length) {
            if (!components[i].hasEvents()) {
                compsToDel.add(components[i]);
            }
            ++i;
        }
        i = 0;
        while (i < compsToDel.size()) {
            eventDef.removeChild(compsToDel.get(i));
            ++i;
        }
    }

    public static void clearDisabledDefElement(EventDef layout) {
        Component[] components = layout.getAllComponents();
        int i = 0;
        while (i < components.length) {
            if (!components[i].hasEvents()) {
                Event[] events = components[i].getAllEvents();
                int j = 0;
                while (j < events.length) {
                    if (events[j].isEnable()) {
                        components[i].removeChild((Object)events[j]);
                    } else if (!events[j].getParam().isEnable()) {
                        events[j].removeChild((Object)events[j].getParam());
                    } else if (!events[j].getResult().isEnable()) {
                        events[j].removeChild((Object)events[j].getResult());
                    }
                    ++j;
                }
            }
            ++i;
        }
        Event[] events = layout.getAllEvents();
        int i2 = 0;
        while (i2 < events.length) {
            if (!events[i2].isEnable()) {
                layout.removeChild((Object)events[i2]);
            } else if (!events[i2].getParam().isEnable()) {
                events[i2].removeChild((Object)events[i2].getParam());
            } else if (!events[i2].getResult().isEnable()) {
                events[i2].removeChild((Object)events[i2].getResult());
            }
            ++i2;
        }
    }

    public static String marshallObj(Object obj, IFile file, IProgressMonitor monitor) throws Exception {
        String result = MaskatBeanIO.writeEventDef((EventDef)((EventDef)obj));
        if (!file.exists()) {
            file.create((InputStream)new ByteArrayInputStream(new byte[0]), false, null);
        }
        file.setContents((InputStream)new ByteArrayInputStream(result.getBytes("UTF-8")), false, false, monitor);
        return result;
    }

    public EventDef getEventDef() {
        return this.eventDef;
    }

    public LayoutDef getLayoutDef() {
        return this.layoutDef;
    }
}

