/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.ui.editors.layout;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jp.sf.maskat.core.layout.ComponentRegistry;
import jp.sf.maskat.core.layout.UnknownComponentClass;
import jp.sf.maskat.ui.MaskatUIPlugin;
import jp.sf.maskat.ui.editors.layout.requests.BeanCreationFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.MarqueeToolEntry;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.SelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.ui.palette.PaletteCustomizer;
import org.eclipse.gef.ui.palette.customize.DefaultEntryPage;
import org.eclipse.gef.ui.palette.customize.DrawerEntryPage;
import org.eclipse.gef.ui.palette.customize.EntryPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class PluggablePaletteCustomizer
extends PaletteCustomizer {
    private static ImageDescriptor DEFAULT_IMAGE_DESCRIPTOR = MaskatUIPlugin.getImageDescriptor("IMG_COMPONENTICON");
    private PaletteRoot paletteRoot = new PaletteRoot();
    private Map entries = new HashMap();

    public PluggablePaletteCustomizer() {
        this.initializePalette();
        this.revertToSaved();
    }

    public PaletteRoot getPaletteRoot() {
        return this.paletteRoot;
    }

    private void initializePalette() {
        int j;
        IConfigurationElement[] elements;
        PaletteGroup group = new PaletteGroup("tools");
        SelectionToolEntry entry = new SelectionToolEntry();
        this.paletteRoot.setDefaultEntry((ToolEntry)entry);
        group.add((PaletteEntry)entry);
        group.add((PaletteEntry)new MarqueeToolEntry());
        this.paletteRoot.add((PaletteEntry)group);
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("jp.sf.maskat.ui", "paletteEntries");
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            elements = extensions[i].getConfigurationElements();
            j = 0;
            while (j < elements.length) {
                if ("drawer".equals(elements[j].getName())) {
                    this.addPaletteDrawer(elements[j]);
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < extensions.length) {
            elements = extensions[i].getConfigurationElements();
            j = 0;
            while (j < elements.length) {
                if ("creationTool".equals(elements[j].getName())) {
                    this.addCreationToolEntry(elements[j]);
                }
                ++j;
            }
            ++i;
        }
        IPreferenceStore store = MaskatUIPlugin.getDefault().getPreferenceStore();
        String storeString = store.getString("paleteEntries");
        this.createPaletteEntry(this.parseStoreEntry(storeString), null);
        Iterator ite = this.entries.keySet().iterator();
        block4: while (ite.hasNext()) {
            PaletteEntry p;
            PaletteEntry px = p = (PaletteEntry)this.entries.get(ite.next());
            PaletteEntry root = null;
            while (px.getParent() != this.paletteRoot) {
                if ((px = px.getParent()) == null) {
                    if (p instanceof PaletteDrawer) continue block4;
                    if (root != null) {
                        this.paletteRoot.add(root);
                        continue block4;
                    }
                    p.setVisible(false);
                    continue block4;
                }
                root = px;
            }
        }
        this.entries.clear();
    }

    private void createPaletteEntry(StoreEntry entry, StoreContainer palent) {
        if (!(entry instanceof RootEntry)) {
            PaletteEntry p = (PaletteEntry)this.entries.get(palent.getId());
            PaletteEntry c = (PaletteEntry)this.entries.get(entry.getId());
            if (c != null) {
                if (p instanceof PaletteDrawer) {
                    ((PaletteDrawer)p).remove(c);
                    ((PaletteDrawer)p).add(c);
                } else if (p == null) {
                    this.paletteRoot.add(c);
                }
                if (!(c instanceof PaletteDrawer)) {
                    this.entries.remove(entry.getId());
                } else if (c instanceof PaletteDrawer && entry instanceof StoreDrawer) {
                    int state;
                    StoreDrawer dr = (StoreDrawer)entry;
                    int n = state = dr.isInitiallyOpen() ? 0 : 1;
                    if (dr.isInitiallyOpen() && dr.isInitiallyPinned()) {
                        state = 2;
                    }
                    ((PaletteDrawer)c).setInitialState(state);
                }
                c.setVisible(entry.isVisible());
            }
        }
        if (entry instanceof StoreContainer) {
            StoreContainer container = (StoreContainer)entry;
            List children = container.getChildren();
            int i = 0;
            while (i < children.size()) {
                this.createPaletteEntry((StoreEntry)children.get(i), container);
                ++i;
            }
        }
    }

    public boolean canDelete(PaletteEntry entry) {
        return false;
    }

    public List getNewEntryFactories() {
        return new ArrayList();
    }

    public EntryPage getPropertiesPage(PaletteEntry entry) {
        if (entry instanceof PaletteDrawer) {
            return new WidgetDrawerEntryPage();
        }
        return new WidgetEntryPage();
    }

    private void addPaletteDrawer(IConfigurationElement element) {
        PaletteDrawer drawer = new PaletteDrawer(element.getAttribute("label"), MaskatUIPlugin.getImageDescriptor(element, "icon"));
        String id = element.getAttribute("id");
        drawer.setId(id);
        this.entries.put(id, drawer);
        String path = element.getAttribute("path");
        if (path != null && this.entries.containsKey(path)) {
            PaletteEntry entryForPath = (PaletteEntry)this.entries.get(path);
            if (entryForPath instanceof PaletteContainer) {
                ((PaletteContainer)entryForPath).add((PaletteEntry)drawer);
            } else {
                entryForPath.getParent().add((PaletteEntry)drawer);
            }
        }
    }

    private void addCreationToolEntry(IConfigurationElement element) {
        String namespaceURI = element.getAttribute("namespaceURI");
        String name = element.getAttribute("name");
        CreationFactory factory = null;
        try {
            if (element.getAttribute("factory") != null) {
                factory = (CreationFactory)element.createExecutableExtension("factory");
            } else {
                Object type;
                IConfigurationElement[] children = element.getChildren("property");
                HashMap<String, String> properties = null;
                if (children != null) {
                    properties = new HashMap<String, String>();
                    int i = 0;
                    while (i < children.length) {
                        String key = children[i].getAttribute("name");
                        String value = children[i].getAttribute("value");
                        properties.put(key, value);
                        ++i;
                    }
                }
                type = (type = ComponentRegistry.getComponentType((String)namespaceURI, (String)name)) == null ? new UnknownComponentClass() : type;
                factory = new BeanCreationFactory(type, properties);
            }
        }
        catch (CoreException e) {
            MaskatUIPlugin.log(e.getStatus());
        }
        ImageDescriptor iconSmall = MaskatUIPlugin.getImageDescriptor(element, "iconSmall");
        ImageDescriptor iconLarge = MaskatUIPlugin.getImageDescriptor(element, "iconLarge");
        CombinedTemplateCreationEntry entry = new CombinedTemplateCreationEntry(element.getAttribute("label"), element.getAttribute("description"), factory, iconSmall != null ? iconSmall : DEFAULT_IMAGE_DESCRIPTOR, iconLarge != null ? iconLarge : DEFAULT_IMAGE_DESCRIPTOR);
        String id = element.getAttribute("id");
        entry.setId(id);
        this.entries.put(id, entry);
        String path = element.getAttribute("path");
        if (path != null && this.entries.containsKey(path)) {
            PaletteEntry entryForPath = (PaletteEntry)this.entries.get(path);
            if (entryForPath instanceof PaletteContainer) {
                ((PaletteContainer)entryForPath).add((PaletteEntry)entry);
            } else {
                entryForPath.getParent().add((PaletteEntry)entry);
            }
        }
    }

    public void revertToSaved() {
    }

    public void save() {
        IPreferenceStore store = MaskatUIPlugin.getDefault().getPreferenceStore();
        StringBuffer sb = new StringBuffer();
        List children = this.paletteRoot.getChildren();
        int i = 0;
        while (i < children.size()) {
            PaletteEntry entry = (PaletteEntry)children.get(i);
            if (!(entry instanceof PaletteGroup)) {
                sb.append(this.getStoreString(entry));
            }
            ++i;
        }
        store.setValue("paleteEntries", sb.toString());
    }

    private String getStoreString(PaletteEntry entry) {
        StringBuffer sb = new StringBuffer();
        sb.append(entry.getId());
        sb.append(":");
        sb.append(entry.getParent() != null ? entry.getParent().getId() : "");
        sb.append(":");
        sb.append(entry.isVisible());
        if (entry instanceof PaletteDrawer) {
            PaletteDrawer drawer = (PaletteDrawer)entry;
            sb.append(":");
            sb.append(drawer.isInitiallyOpen());
            sb.append(":");
            sb.append(drawer.isInitiallyPinned());
            sb.append(";");
            List children = ((PaletteContainer)entry).getChildren();
            int i = 0;
            while (i < children.size()) {
                sb.append(this.getStoreString((PaletteEntry)children.get(i)));
                ++i;
            }
        } else {
            sb.append(";");
        }
        return sb.toString();
    }

    private StoreEntry parseStoreEntry(String value) {
        RootEntry root = new RootEntry();
        if (value == null) {
            return root;
        }
        String[] entries = value.split(";");
        int i = 0;
        while (i < entries.length) {
            String[] values;
            if (!"".equals(entries[i].trim()) && (values = entries[i].split(":")).length >= 3) {
                String id = values[0];
                String parentId = values[1];
                boolean visible = new Boolean(values[2]);
                StoreEntry entry = values.length == 5 ? new StoreDrawer(id, visible, new Boolean(values[3]), new Boolean(values[4])) : new StoreEntry(id, visible);
                root.addChild(entry, parentId);
            }
            ++i;
        }
        return root;
    }

    private class WidgetDrawerEntryPage
    extends DrawerEntryPage {
        private WidgetDrawerEntryPage() {
        }

        protected Text createDescText(Composite panel) {
            Text text = super.createDescText(panel);
            text.setEditable(false);
            return text;
        }

        protected Text createNameText(Composite panel) {
            Text text = super.createNameText(panel);
            text.setEditable(false);
            return text;
        }
    }

    private class WidgetEntryPage
    extends DefaultEntryPage {
        private WidgetEntryPage() {
        }

        protected Text createDescText(Composite panel) {
            Text text = super.createDescText(panel);
            text.setEditable(false);
            return text;
        }

        protected Text createNameText(Composite panel) {
            Text text = super.createNameText(panel);
            text.setEditable(false);
            return text;
        }
    }

    private class RootEntry
    extends StoreContainer {
        private RootEntry() {
        }
    }

    private class StoreDrawer
    extends StoreContainer {
        private boolean initiallyOpen = false;
        private boolean initiallyPinned = false;

        public StoreDrawer(String id, boolean visible, boolean open, boolean pin) {
            super(id, visible);
            this.initiallyOpen = open;
            this.initiallyPinned = pin;
        }

        public boolean isInitiallyOpen() {
            return this.initiallyOpen;
        }

        public void setInitiallyOpen(boolean initiallyOpen) {
            this.initiallyOpen = initiallyOpen;
        }

        public boolean isInitiallyPinned() {
            return this.initiallyPinned;
        }

        public void setInitiallyPinned(boolean initiallyPinned) {
            this.initiallyPinned = initiallyPinned;
        }
    }

    private class StoreContainer
    extends StoreEntry {
        private List children = new ArrayList();

        public StoreContainer() {
            super("", false);
        }

        public StoreContainer(String id, boolean visible) {
            super(id, visible);
        }

        public List getChildren() {
            return this.children;
        }

        public void addChild(StoreEntry child) {
            this.children.add(child);
        }

        public boolean addChild(StoreEntry child, String parentId) {
            if ("".equals(parentId) || this.getId().equals(parentId)) {
                this.addChild(child);
                return true;
            }
            int i = 0;
            while (i < this.children.size()) {
                boolean result;
                StoreEntry entry = (StoreEntry)this.children.get(i);
                if (entry instanceof StoreContainer && (result = ((StoreContainer)entry).addChild(child, parentId))) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public void setChildren(List children) {
            this.children = children;
        }
    }

    private class StoreEntry {
        private String id = "";
        private boolean visible = false;

        public StoreEntry() {
        }

        public StoreEntry(String id, boolean visible) {
            this.id = id;
            this.visible = visible;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void setVisible(boolean visible) {
            this.visible = visible;
        }
    }
}

