/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.ui.editors.layout.actions;

import java.util.ArrayList;
import java.util.List;
import jp.sf.maskat.core.MaskatElement;
import jp.sf.maskat.core.layout.LayoutElement;
import jp.sf.maskat.ui.MaskatUIPlugin;
import jp.sf.maskat.ui.Messages;
import jp.sf.maskat.ui.editors.layout.editparts.ComponentEditPart;
import jp.sf.maskat.ui.editors.layout.editparts.LayoutElementEditPart;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.internal.GEFMessages;
import org.eclipse.gef.ui.actions.Clipboard;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class CopyComponentAction
extends SelectionAction {
    public CopyComponentAction(IWorkbenchPart part) {
        super(part);
        this.setId(ActionFactory.COPY.getId());
        this.setText(GEFMessages.CopyAction_Label);
        this.setToolTipText(GEFMessages.CopyAction_Tooltip);
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
    }

    protected boolean calculateEnabled() {
        List objects = this.getSelectedObjects();
        if (objects.isEmpty()) {
            return false;
        }
        int i = 0;
        while (i < objects.size()) {
            EditPart part = (EditPart)objects.get(i);
            if (!(part instanceof ComponentEditPart)) {
                return false;
            }
            if (!((LayoutElementEditPart)part).canCopy()) {
                return false;
            }
            ++i;
        }
        EditPart parent = ((EditPart)objects.get(0)).getParent();
        int i2 = 1;
        while (i2 < objects.size()) {
            EditPart parent2 = ((EditPart)objects.get(i2)).getParent();
            if (parent2 != parent) {
                return false;
            }
            if (objects.contains(parent2)) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public void run() {
        Object model;
        List editparts = this.getSelectedObjects();
        ArrayList<Object> copyTarget = new ArrayList<Object>();
        int i = 0;
        while (i < editparts.size()) {
            EditPart agep = (EditPart)editparts.get(i);
            model = agep.getModel();
            copyTarget.add(model);
            ++i;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        int i2 = 0;
        while (i2 < copyTarget.size()) {
            LayoutElement def;
            model = copyTarget.get(i2);
            if (!result.contains(model) && !this.isAnscestorContained(copyTarget, (MaskatElement)(def = (LayoutElement)model))) {
                try {
                    result.add(def.clone());
                }
                catch (CloneNotSupportedException e) {
                    MessageDialog.openError((Shell)this.getWorkbenchPart().getSite().getShell(), (String)Messages.getString("layout.cmd.msg.error.title"), (String)Messages.getString("layout.cmd.copy.msg.error"));
                    MaskatUIPlugin.log((IStatus)new Status(4, "jp.sf.maskat.ui", 4, e.getMessage(), (Throwable)e));
                }
            }
            ++i2;
        }
        Clipboard.getDefault().setContents(result);
    }

    private boolean isAnscestorContained(List list, MaskatElement def) {
        if (def == null || list == null) {
            return false;
        }
        MaskatElement parentDef = def.getParent();
        while (parentDef != null) {
            if (list.contains(parentDef)) {
                return true;
            }
            parentDef = parentDef.getParent();
        }
        return false;
    }
}

