/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.ui.editors.layout.editpolicies;

import java.util.ArrayList;
import java.util.List;
import jp.sf.maskat.core.MaskatElement;
import jp.sf.maskat.core.layout.Component;
import jp.sf.maskat.core.layout.LayoutElement;
import jp.sf.maskat.ui.editors.layout.commands.AddComponentCommand;
import jp.sf.maskat.ui.editors.layout.commands.OrphanChildrenCommand;
import jp.sf.maskat.ui.editors.layout.editparts.LayoutElementEditPart;
import jp.sf.maskat.ui.editors.layout.editpolicies.FeedBackComponentEditPolicy;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.GroupRequest;

public class ComponentXYLayoutEditPolicy
extends XYLayoutEditPolicy {
    private int feedBackStyle = 0;

    public ComponentXYLayoutEditPolicy() {
    }

    public ComponentXYLayoutEditPolicy(int style) {
        this.setFeedBackStyle(style);
    }

    protected Command createAddCommand(EditPart child, Object constraint) {
        Object childModel = child.getModel();
        EditPart parentEditPart = this.getHost();
        Object parent = parentEditPart.getModel();
        if (!(childModel instanceof Component)) {
            return null;
        }
        if (!(!(parentEditPart instanceof LayoutElementEditPart) || childModel instanceof LayoutElement && ((LayoutElementEditPart)parentEditPart).canAddChild((LayoutElement)childModel))) {
            return null;
        }
        if (child instanceof LayoutElementEditPart && parentEditPart instanceof EditPart && !((LayoutElementEditPart)child).canAddParent(parentEditPart.getModel())) {
            return null;
        }
        AddComponentCommand command = null;
        if (this.isCheckConstraint((Rectangle)constraint)) {
            command = new AddComponentCommand((Component)parent, (Component)childModel);
            command.setConstraint((Rectangle)constraint);
        }
        return command;
    }

    protected Command createChangeConstraintCommand(EditPart child, Object constraint) {
        Command cmd = null;
        if (child instanceof LayoutElementEditPart && this.isCheckConstraint((Rectangle)constraint)) {
            LayoutElementEditPart part = (LayoutElementEditPart)child;
            cmd = part.createConstrainCommand(child.getModel(), (Rectangle)constraint);
        }
        return cmd;
    }

    private boolean isCheckConstraint(Rectangle rec) {
        return rec.x >= 0 && rec.y >= 0;
    }

    protected Command getCreateCommand(CreateRequest request) {
        Object model = this.getHost().getModel();
        Command cmd = null;
        if (model instanceof Component) {
            LayoutElementEditPart part;
            MaskatElement host = (MaskatElement)model;
            Object node = request.getNewObject();
            EditPart editPart = this.getHost();
            if (editPart instanceof LayoutElementEditPart && !(part = (LayoutElementEditPart)editPart).canAddChild((LayoutElement)node)) {
                return null;
            }
            LayoutElementEditPart child = (LayoutElementEditPart)this.getHost().getViewer().getEditPartFactory().createEditPart(null, node);
            if (!child.canAddParent(editPart.getModel())) {
                return null;
            }
            cmd = child.getCreateCommand(host, node);
            if (cmd != null && cmd instanceof AddComponentCommand) {
                ((AddComponentCommand)cmd).setConstraint((Rectangle)this.getConstraintFor(request));
            }
        }
        return cmd;
    }

    protected Command getOrphanChildrenCommand(Request request) {
        Object obj = this.getHost().getModel();
        if (obj instanceof Component && ((Component)obj).getChildren().size() > 0) {
            List editParts = ((GroupRequest)request).getEditParts();
            ArrayList<Object> models = new ArrayList<Object>();
            int i = 0;
            while (i < editParts.size()) {
                models.add(((EditPart)editParts.get(i)).getModel());
                ++i;
            }
            OrphanChildrenCommand command = new OrphanChildrenCommand(models);
            return command;
        }
        return null;
    }

    protected Command getDeleteDependantCommand(Request request) {
        return null;
    }

    protected Command getCloneCommand(ChangeBoundsRequest request) {
        return super.getCloneCommand(request);
    }

    public void setFeedBackStyle(int style) {
        this.feedBackStyle = style;
    }

    public int getFeedBackStyle() {
        return this.feedBackStyle;
    }

    protected EditPolicy createChildEditPolicy(EditPart child) {
        int style = 0;
        EditPolicy policy = child.getEditPolicy((Object)"LayoutEditPolicy");
        if (policy instanceof ComponentXYLayoutEditPolicy) {
            style = ((ComponentXYLayoutEditPolicy)policy).getFeedBackStyle();
        }
        return new FeedBackComponentEditPolicy(style);
    }
}

