/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.ui.editors.preview;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import jp.sf.maskat.core.MaskatElementVisitor;
import jp.sf.maskat.core.betwixt.MaskatBeanIO;
import jp.sf.maskat.core.layout.Component;
import jp.sf.maskat.core.layout.LayoutDef;
import jp.sf.maskat.runtime.MaskatRuntimePlugin;
import jp.sf.maskat.ui.MaskatNature;
import jp.sf.maskat.ui.Messages;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public class LayoutPreviewBrowser
extends EditorPart {
    public static final String EDITOR_ID = "jp.sf.maskat.ui.layoutPreviewBrowser";
    private Browser browser;
    static /* synthetic */ Class class$0;

    public void createPartControl(Composite parent) {
        ScrolledComposite composite = new ScrolledComposite(parent, 768);
        composite.setLayout((Layout)new FillLayout());
        composite.setExpandHorizontal(true);
        composite.setExpandVertical(true);
        this.browser = new Browser((Composite)composite, 0);
        composite.setContent((Control)this.browser);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSave(IProgressMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    public void doSaveAs() {
        throw new UnsupportedOperationException();
    }

    public void setFocus() {
        try {
            this.browser.setUrl(this.generateContents().toString());
        }
        catch (Exception exception) {
            this.browser.setText(Messages.getString("preview.create.msg.error"));
        }
        this.browser.setFocus();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private URL generateContents() throws IOException, CoreException {
        IEditorInput iEditorInput = this.getEditorInput();
        Class<?> clazz = class$0;
        if (clazz == null) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz = class$0 = clazz2;
        }
        IFile file = (IFile)iEditorInput.getAdapter((Class)clazz);
        String frameworkBase = MaskatRuntimePlugin.getFrameworkBaseURL().toString();
        try {
            MaskatNature nature = MaskatNature.getNature(file.getProject());
            if (nature != null) {
                URI uri = nature.getProject().getLocationURI();
                String fwPath = nature.getMaskatFrameworkPath().toString();
                if (fwPath != null && !fwPath.startsWith("/")) {
                    fwPath = "/" + fwPath;
                }
                uri = new URI(String.valueOf(uri.toString()) + fwPath + "/");
                frameworkBase = FileLocator.toFileURL((URL)uri.toURL()).toString();
            }
        }
        catch (URISyntaxException uRISyntaxException) {}
        InputStream in = null;
        final Rectangle rec = this.browser.getBounds();
        try {
            try {
                in = file.getContents(true);
                LayoutDef layoutDef = MaskatBeanIO.readLayoutDef((InputStream)in);
                layoutDef.getLayouts()[0].accept(new MaskatElementVisitor(){

                    public void visit(Object def) {
                        if (def instanceof Component) {
                            Component comp = (Component)def;
                            rec.width = Math.max(rec.width, comp.getLeft() + comp.getWidth() + 50);
                            rec.height = Math.max(rec.height, comp.getTop() + comp.getHeight() + 50);
                        }
                    }
                });
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            IOUtils.closeQuietly((InputStream)in);
            throw throwable;
        }
        {
            Object var6_10 = null;
        }
        IOUtils.closeQuietly((InputStream)in);
        ((ScrolledComposite)this.browser.getParent()).setMinSize(rec.width, rec.height);
        File idxFile = File.createTempFile("_maskat", "idx");
        File tmpFolder = new File(idxFile.getParentFile().getAbsoluteFile(), "_maskat");
        tmpFolder.mkdir();
        tmpFolder.deleteOnExit();
        idxFile.delete();
        InputStream containerIn = null;
        BufferedOutputStream containerOut = null;
        File containerFile = null;
        try {
            containerFile = new File(tmpFolder, "preview.html");
            containerFile.createNewFile();
            containerFile.deleteOnExit();
            containerOut = new BufferedOutputStream(new FileOutputStream(containerFile));
            containerIn = ((Object)((Object)this)).getClass().getResourceAsStream("preview.html");
            String html = IOUtils.toString((InputStream)containerIn, (String)"UTF-8");
            ((OutputStream)containerOut).write(html.replaceAll("\\Q${maskatFW}\\E", frameworkBase).getBytes("UTF-8"));
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            IOUtils.closeQuietly(containerIn);
            IOUtils.closeQuietly(containerOut);
            throw throwable;
        }
        {
            Object var11_16 = null;
        }
        IOUtils.closeQuietly((InputStream)containerIn);
        IOUtils.closeQuietly((OutputStream)containerOut);
        this.copyFile(file, new File(tmpFolder, "layout.xml"));
        this.copyFile("layout_e.xml", new File(tmpFolder, "layout_e.xml"));
        this.copyFile("transition.xml", new File(tmpFolder, "transition.xml"));
        String path = file.getParent().getName();
        try {
            IFile jsonResouce = file.getProject().getFile(String.valueOf(path) + "/properties.json");
            this.copyFile(jsonResouce, new File(tmpFolder, "properties.json"));
        }
        catch (CoreException coreException) {}
        if (containerFile == null) return null;
        URL uRL = containerFile.toURL();
        return uRL;
    }

    private void copyFile(String resourceName, File createFile) throws IOException {
        this.copyFile(((Object)((Object)this)).getClass().getResourceAsStream(resourceName), createFile);
    }

    private void copyFile(IFile resource, File createFile) throws IOException, CoreException {
        this.copyFile(resource.getContents(true), createFile);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void copyFile(InputStream in, File createFile) throws IOException {
        BufferedOutputStream out = null;
        try {
            if (in != null) {
                createFile.createNewFile();
                createFile.deleteOnExit();
                out = new BufferedOutputStream(new FileOutputStream(createFile));
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly(out);
    }
}

