/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.ui.views.properties.descriptor;

import jp.sf.maskat.ui.views.properties.descriptor.Category;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;

public class MaskatComboBoxPropertyDescriptor
extends ComboBoxPropertyDescriptor {
    private String[] labels;

    public MaskatComboBoxPropertyDescriptor(Object id, String displayName, String[] labels) {
        super(id, displayName, labels);
        this.labels = labels;
        this.setLabelProvider((ILabelProvider)new TextLabelProvider());
        this.setCategory(Category.getCategory(displayName));
    }

    public CellEditor createPropertyEditor(Composite parent) {
        TextComboBoxCellEditor editor = new TextComboBoxCellEditor(parent, this.labels, 8);
        if (this.getValidator() != null) {
            editor.setValidator(this.getValidator());
        }
        return editor;
    }

    private int indexOfLabel(String item) {
        int i = 0;
        while (i < this.labels.length && item != null) {
            if (item.equals(this.labels[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private class TextLabelProvider
    extends LabelProvider {
        private TextLabelProvider() {
        }

        public String getText(Object element) {
            return element.toString();
        }
    }

    private class TextComboBoxCellEditor
    extends ComboBoxCellEditor {
        public TextComboBoxCellEditor(Composite parent, String[] items, int style) {
            super(parent, items, style);
        }

        protected void doSetValue(Object value) {
            super.doSetValue((Object)new Integer(MaskatComboBoxPropertyDescriptor.this.indexOfLabel(value.toString())));
        }

        protected Object doGetValue() {
            int index;
            Object value = super.doGetValue();
            int n = index = value instanceof Integer ? (Integer)value : -1;
            if (index < 0 || index >= MaskatComboBoxPropertyDescriptor.this.labels.length) {
                return "";
            }
            return MaskatComboBoxPropertyDescriptor.this.labels[index];
        }
    }
}

