/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.ui.views.properties.tabbed.command;

import jp.sf.maskat.ui.MaskatUIPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class SetEnabledCommand
extends Command {
    private Control control;
    private boolean enabled;
    private String text;

    public SetEnabledCommand(Control control, boolean enabled) {
        this.control = control;
        this.enabled = enabled;
        if (control instanceof Text) {
            this.text = ((Text)control).getText();
        }
    }

    public void execute() {
        try {
            if (this.control.getEnabled() != this.enabled) {
                this.enabledControl(this.control, this.enabled);
            }
        }
        catch (Exception e) {
            MaskatUIPlugin.log((IStatus)new Status(4, "jp.sf.maskat.ui", 4, e.getMessage(), (Throwable)e));
        }
    }

    public void undo() {
        try {
            if (this.control.getEnabled() != !this.enabled) {
                this.enabledControl(this.control, !this.enabled);
            }
        }
        catch (Exception e) {
            MaskatUIPlugin.log((IStatus)new Status(4, "jp.sf.maskat.ui", 4, e.getMessage(), (Throwable)e));
        }
    }

    private void enabledControl(Control control, boolean enabled) {
        if (control instanceof Text) {
            this.enabledControl((Text)control, enabled);
        } else {
            control.setEnabled(enabled);
        }
    }

    private void enabledControl(Text text, boolean enabled) {
        if (enabled) {
            text.setText(this.text);
        } else {
            text.setText("");
        }
        text.setEnabled(enabled);
    }
}

