/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.ui.wizards.export;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import jp.sf.maskat.core.betwixt.MaskatBeanIO;
import jp.sf.maskat.core.event.Component;
import jp.sf.maskat.core.event.Event;
import jp.sf.maskat.core.event.EventDef;
import jp.sf.maskat.core.event.EventElement;
import jp.sf.maskat.core.event.EventRef;
import jp.sf.maskat.core.event.Param;
import jp.sf.maskat.core.event.Result;
import jp.sf.maskat.ui.MaskatUIPlugin;
import jp.sf.maskat.ui.Messages;
import jp.sf.maskat.ui.wizards.export.ExportMessage;
import jp.sf.maskat.ui.wizards.export.XMLSchemaSelectionDialog;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;

public class ExportMessageSchemaDialogArea
extends Composite {
    private Text eventFilePath;
    private Text outputFilePath;
    private boolean valid;
    private String errorMessage;
    private IResource initPath;
    private Tree exportEventTree = null;
    private ContainerCheckedTreeViewer exportEventTreeViewer = null;
    private HashMap refMap = new HashMap();
    static /* synthetic */ Class class$0;

    public ExportMessageSchemaDialogArea(Composite parent, int style, IResource path) {
        super(parent, style);
        this.initPath = path;
        this.createControl();
    }

    private void createControl() {
        this.setLayout((Layout)new GridLayout(4, false));
        this.setLayoutData(new GridData(768));
        Label dirLabel = new Label((Composite)this, 0);
        dirLabel.setText(Messages.getString("exportSchemaWizard.label.eventName"));
        this.eventFilePath = new Text((Composite)this, 2048);
        this.eventFilePath.setEditable(false);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.eventFilePath.setLayoutData((Object)gridData);
        Button button = new Button((Composite)this, 8);
        button.setText(Messages.getString("exportSchemaWizard.button.browse"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IResource file = ExportMessageSchemaDialogArea.this.inputHandleBrowse();
                if (file != null) {
                    ExportMessageSchemaDialogArea.this.eventFilePath.setText(file.getFullPath().toString());
                    ExportMessageSchemaDialogArea.this.createEventTreeView(file);
                    ExportMessageSchemaDialogArea.this.setValid(ExportMessageSchemaDialogArea.this.validatePage());
                }
            }
        });
        if (this.initPath == null) {
            button.setEnabled(false);
        }
        Label selectLabel = new Label((Composite)this, 0);
        selectLabel.setText(Messages.getString("exportSchemaWizard.label.selectEvent"));
        GridData treeData = new GridData();
        treeData.horizontalAlignment = 4;
        treeData.horizontalSpan = 4;
        treeData.grabExcessVerticalSpace = true;
        treeData.grabExcessHorizontalSpace = true;
        treeData.verticalAlignment = 4;
        this.exportEventTree = new Tree((Composite)this, 2080);
        this.exportEventTree.setHeaderVisible(false);
        this.exportEventTree.setLayoutData((Object)treeData);
        this.exportEventTreeViewer = new ContainerCheckedTreeViewer(this.exportEventTree);
        this.exportEventTreeViewer.setContentProvider((IContentProvider)new EvnetContentProvider());
        this.exportEventTreeViewer.setLabelProvider((IBaseLabelProvider)new EventLabelProvider());
        this.exportEventTreeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ExportMessageSchemaDialogArea.this.validatePage();
            }
        });
        Label outDirLabel = new Label((Composite)this, 0);
        outDirLabel.setText(Messages.getString("exportSchemaWizard.label.outputDirectory"));
        this.outputFilePath = new Text((Composite)this, 2048);
        GridData outData = new GridData(768);
        outData.horizontalSpan = 2;
        this.outputFilePath.setLayoutData((Object)outData);
        this.outputFilePath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportMessageSchemaDialogArea.this.setValid(ExportMessageSchemaDialogArea.this.validatePage());
            }
        });
        Button outBrowsen = new Button((Composite)this, 8);
        outBrowsen.setText(Messages.getString("exportSchemaWizard.button.browse.output"));
        outBrowsen.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String path = ExportMessageSchemaDialogArea.this.outputHandleBrowse();
                if (path != null) {
                    ExportMessageSchemaDialogArea.this.outputFilePath.setText(path);
                    ExportMessageSchemaDialogArea.this.setValid(ExportMessageSchemaDialogArea.this.validatePage());
                }
            }
        });
    }

    public void initialize() {
        this.eventFilePath.setText(this.initPath == null ? "" : this.initPath.getFullPath().toString());
        this.outputFilePath.setText("");
        this.createEventTreeView(this.initPath);
        this.setErrorMessage(null);
    }

    private void createEventTreeView(IResource resouce) {
        if (resouce != null && resouce.getType() == 1) {
            try {
                EventDef eventDef = MaskatBeanIO.readEventDef((String)((IFile)resouce).getLocationURI().getPath());
                if (eventDef == null) {
                    this.exportEventTreeViewer.setInput(null);
                } else {
                    this.setEventRefElements(eventDef);
                    this.exportEventTreeViewer.setInput((Object)eventDef);
                    this.exportEventTreeViewer.expandAll();
                    this.exportEventTreeViewer.setAllChecked(true);
                }
            }
            catch (Exception e) {
                this.exportEventTreeViewer.setInput(null);
                MaskatUIPlugin.log((IStatus)new Status(4, "jp.sf.maskat.ui", 4, e.getMessage(), (Throwable)e));
            }
        }
    }

    private void setEventRefElements(EventDef eventDef) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("jp.sf.maskat.core.event.EventRef");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        List eventRefs = eventDef.getTypedChildren((Class)clazz);
        int i = 0;
        while (i < eventRefs.size()) {
            EventRef ref = (EventRef)eventRefs.get(i);
            this.refMap.put(ref.getRefid(), ref);
            ++i;
        }
    }

    private IResource inputHandleBrowse() {
        XMLSchemaSelectionDialog dialog = new XMLSchemaSelectionDialog(this.getShell(), (IAdaptable)this.initPath, Messages.getString("exportSchemaWizard.browse.title"));
        if (dialog.open() == 0) {
            return dialog.getSelectEventXMLFile();
        }
        return null;
    }

    private String outputHandleBrowse() {
        String init = this.initPath == null ? "" : this.initPath.getLocation().toString();
        DirectoryDialog selectionDialog = new DirectoryDialog(this.getShell());
        selectionDialog.setFilterPath(init);
        return selectionDialog.open();
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String newMessage) {
        this.errorMessage = newMessage;
    }

    public boolean validatePage() {
        String path = this.outputFilePath.getText();
        if (path == null || path.length() == 0) {
            this.setErrorMessage(Messages.getString("exportSchemaWizard.msg.error.notdir"));
            this.outputFilePath.setFocus();
            return false;
        }
        if (!new File(path).isDirectory()) {
            Object[] msgArgs = new String[]{path};
            this.setErrorMessage(Messages.format("exportSchemaWizard.msg.error.invaliddir", msgArgs));
            this.outputFilePath.setFocus();
            return false;
        }
        if (!this.isWriteDirectory(new File(path))) {
            Object[] msgArgs = new String[]{path};
            this.setErrorMessage(Messages.format("exportSchemaWizard.msg.error.nowritedir", msgArgs));
            this.outputFilePath.setFocus();
            return false;
        }
        Object[] selected = this.exportEventTreeViewer.getCheckedElements();
        if (selected.length <= 0) {
            this.setErrorMessage(Messages.getString("exportSchemaWizard.msg.error.notselected"));
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private boolean isWriteDirectory(File dir) {
        if (!dir.isDirectory()) {
            return false;
        }
        try {
            File tmp = File.createTempFile("_maskat", null, dir);
            tmp.delete();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public void setEventFilePath(String path) {
        this.eventFilePath.setText(path);
    }

    public String getEventFilePath() {
        return this.eventFilePath.getText();
    }

    public void setOutputFilePath(String path) {
        this.outputFilePath.setText(path);
    }

    public String getOutputFilePath() {
        return this.outputFilePath.getText();
    }

    public ExportMessage[] getSelectedMessages() {
        Object[] selected = this.exportEventTreeViewer.getCheckedElements();
        ArrayList<ExportMessage> list = new ArrayList<ExportMessage>();
        int i = 0;
        while (i < selected.length) {
            EventElement element = (EventElement)selected[i];
            if (element instanceof Event) {
                Event event = (Event)element;
                String ref = event.getRef();
                if (ref != null) {
                    element = (Event)this.refMap.get(ref);
                }
                List elements = element.getChildren();
                int j = 0;
                while (j < elements.size()) {
                    Object object = elements.get(j);
                    if (object instanceof Param || object instanceof Result) {
                        list.add(new ExportMessage(event, (EventElement)object));
                    }
                    ++j;
                }
            }
            ++i;
        }
        return list.toArray(new ExportMessage[0]);
    }

    private class EvnetContentProvider
    implements ITreeContentProvider {
        private EvnetContentProvider() {
        }

        private Object getElement(Object element) {
            if (element instanceof Component) {
                List elements = ((Component)element).getChildren();
                int i = 0;
                if (i < elements.size()) {
                    return this.getElement(elements.get(i)) != null ? element : null;
                }
            }
            if (element instanceof Event && !(element instanceof EventRef)) {
                return "remote".equals(((Event)element).getType()) ? element : null;
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            ArrayList<Object> list = new ArrayList<Object>();
            EventElement element = (EventElement)parentElement;
            if (parentElement != null) {
                List elements = element.getChildren();
                int i = 0;
                while (i < elements.size()) {
                    Object object = this.getElement(elements.get(i));
                    if (object != null) {
                        list.add(object);
                    }
                    ++i;
                }
            }
            return list.toArray();
        }

        public Object getParent(Object element) {
            EventElement parentElement = (EventElement)element;
            return parentElement.getParent();
        }

        public boolean hasChildren(Object element) {
            return element instanceof Component;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class EventLabelProvider
    extends LabelProvider {
        Image evnetImage = MaskatUIPlugin.getImage("IMG_COMPONENT_TEXT");

        private EventLabelProvider() {
        }

        public String getText(Object element) {
            EventElement e = (EventElement)element;
            if (e instanceof Event) {
                return ((Event)e).getId();
            }
            if (e instanceof Component) {
                return ((Component)e).getId();
            }
            return null;
        }

        public Image getImage(Object element) {
            return this.evnetImage;
        }
    }
}

