/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.ui.wizards.export;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jp.sf.maskat.core.betwixt.MessageSchemaGenerator;
import jp.sf.maskat.core.event.Param;
import jp.sf.maskat.core.event.Result;
import jp.sf.maskat.ui.MaskatUIPlugin;
import jp.sf.maskat.ui.Messages;
import jp.sf.maskat.ui.wizards.export.ExportMessage;
import jp.sf.maskat.ui.wizards.export.ExportMessageSchemaWizardPage;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class ExportMessageSchemaWizard
extends Wizard
implements IExportWizard {
    private IStructuredSelection selection;
    private ExportMessageSchemaWizardPage page;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    public void addPages() {
        Object select;
        IResource selectedElement = null;
        if (this.selection != null && (select = this.selection.getFirstElement()) instanceof IResource) {
            selectedElement = (IResource)select;
        }
        this.page = new ExportMessageSchemaWizardPage(selectedElement);
        this.setWindowTitle(Messages.getString("exportSchemaWizard.windowtitle"));
        this.addPage((IWizardPage)this.page);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean performFinish() {
        ExportMessage[] msg = this.page.getSelectedMessages();
        IPath outPath = this.page.getOutputFilePath();
        String baseDir = outPath.toFile().getAbsolutePath();
        byte[] buffer = new byte[2048];
        int i = 0;
        while (true) {
            Object var14_16;
            OutputStream out;
            InputStream in;
            block21: {
                block20: {
                    if (i >= msg.length) {
                        return true;
                    }
                    in = null;
                    out = null;
                    String cmpName = msg[i].getComponentName();
                    if (cmpName == null) {
                        cmpName = "root";
                    }
                    StringBuffer sb = new StringBuffer(baseDir);
                    sb.append("/");
                    sb.append(cmpName);
                    File dir = new File(sb.toString());
                    dir.mkdirs();
                    try {
                        try {
                            int cnt;
                            in = msg[i].getType() == "request" ? MessageSchemaGenerator.generateRequestXMLSchema((Param)((Param)msg[i].getElement())) : MessageSchemaGenerator.generateResponseXMLSchema((Result)((Result)msg[i].getElement()));
                            File directory = new File(dir.getPath());
                            File saveFile = new File(directory, msg[i].getFileName());
                            if (saveFile.exists() && !saveFile.canWrite()) {
                                Object[] msgArgs = new String[]{msg[i].getFileName()};
                                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.getString("exportSchemaWizard.msg.error.title"), (String)Messages.format("exportSchemaWizard.msg.error.notwrite", msgArgs));
                                var14_16 = null;
                                break block20;
                            }
                            out = new BufferedOutputStream(new FileOutputStream(saveFile));
                            while ((cnt = in.read(buffer)) != -1) {
                                out.write(buffer, 0, cnt);
                            }
                            break block21;
                        }
                        catch (Exception e) {
                            MaskatUIPlugin.log((IStatus)new Status(4, "jp.sf.maskat.ui", 4, e.getMessage(), (Throwable)e));
                            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.getString("exportSchemaWizard.msg.error.title"), (String)Messages.getString("exportSchemaWizard.msg.error.notwrite"));
                            var14_16 = null;
                            try {
                                if (in != null) {
                                    in.close();
                                }
                                if (out == null) return false;
                                out.close();
                                return false;
                            }
                            catch (IOException iOException) {}
                            return false;
                        }
                    }
                    catch (Throwable throwable) {
                        var14_16 = null;
                        try {}
                        catch (IOException iOException) {}
                        if (in != null) {
                            in.close();
                        }
                        if (out == null) throw throwable;
                        out.close();
                        throw throwable;
                        throw throwable;
                    }
                }
                try {}
                catch (IOException iOException) {
                    return true;
                }
                if (in != null) {
                    in.close();
                }
                if (out == null) return true;
                out.close();
                return true;
            }
            var14_16 = null;
            try {}
            catch (IOException iOException) {}
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
            ++i;
        }
    }
}

