/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.widget.rialto.editpart;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jp.sf.maskat.core.MaskatElement;
import jp.sf.maskat.core.layout.Component;
import jp.sf.maskat.core.layout.DynaComponent;
import jp.sf.maskat.core.layout.DynaComponentClass;
import jp.sf.maskat.ui.editors.layout.editparts.ComponentEditPart;
import jp.sf.maskat.ui.editors.layout.editparts.VerticalResizable;
import jp.sf.maskat.widget.rialto.editpart.GridHeaderEditPart;
import jp.sf.maskat.widget.rialto.figure.GridFigure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;

public class GridEditPart
extends ComponentEditPart
implements VerticalResizable {
    protected IFigure createFigure() {
        return new GridFigure(this);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("text".equals(evt.getPropertyName())) {
            this.getFigure().repaint();
        } else if ("gridHeaderTitle".equals(evt.getPropertyName()) || "gridHeaderWidth".equals(evt.getPropertyName()) || "lineHeight".equals(evt.getPropertyName())) {
            Iterator it = this.getChildren().iterator();
            while (it != null && it.hasNext()) {
                ((AbstractGraphicalEditPart)it.next()).refresh();
            }
            this.getFigure().repaint();
        } else if ("addChild".equals(evt.getPropertyName()) || "removeChild".equals(evt.getPropertyName())) {
            this.refresh();
            Iterator it = this.getChildren().iterator();
            while (it != null && it.hasNext()) {
                ((AbstractGraphicalEditPart)it.next()).refresh();
            }
            this.getFigure().repaint();
        }
        super.propertyChange(evt);
    }

    protected List getModelChildren() {
        List result = null;
        if (this.getModel() instanceof MaskatElement) {
            result = ((MaskatElement)this.getModel()).getChildren();
        }
        if (result != null) {
            return result;
        }
        return super.getModelChildren();
    }

    protected void refreshVisuals() {
        Component comp = (Component)this.getModel();
        int width = this.headerTotalWidth();
        if (width == 0) {
            width = GridFigure.DEFAULT_WIDTH;
        }
        Rectangle constraint = new Rectangle(comp.getLeft(), comp.getTop(), width, comp.getHeight());
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)constraint);
    }

    public void refreshGridWidget() {
        List headers = this.getHeadersIt();
        int i = 0;
        while (i < headers.size()) {
            ((GridHeaderEditPart)((Object)headers.get(i))).refreshVisuals();
            ++i;
        }
        this.refreshVisuals();
    }

    public List getHeadersIt() {
        ArrayList result = new ArrayList();
        List children = this.getChildren();
        int i = 0;
        while (i < children.size()) {
            Object obj = children.get(i);
            if (obj instanceof GridHeaderEditPart) {
                result.add(obj);
            }
            ++i;
        }
        return result;
    }

    public int headerTotalWidth() {
        int result = 0;
        List headers = ((Component)this.getModel()).getChildren();
        int i = 0;
        while (i < headers.size()) {
            DynaComponent header;
            Object child = headers.get(i);
            if (child instanceof DynaComponent && "gridHeader".equals((header = (DynaComponent)child).getDynaClass().getName())) {
                result += header.getWidth();
            }
            ++i;
        }
        return result;
    }

    public int indexOfHeader(GridHeaderEditPart headerDef) {
        List headers = this.getHeadersIt();
        int i = 0;
        while (i < headers.size()) {
            Object obj = headers.get(i);
            if (obj instanceof GridHeaderEditPart && obj == headerDef) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean canAddChild(Object widget) {
        if (widget instanceof DynaComponent) {
            DynaComponentClass child = (DynaComponentClass)((DynaComponent)widget).getDynaClass();
            DynaComponentClass dynaClass = (DynaComponentClass)((DynaComponent)this.getModel()).getDynaClass();
            if (dynaClass.getLibrary() == child.getLibrary() && "gridHeader".equals(child.getName())) {
                return true;
            }
            if (dynaClass.getLibrary() == child.getLibrary() && "gridLine".equals(child.getName())) {
                return true;
            }
        }
        return false;
    }

    public int getLineHeight() {
        return (Integer)((DynaComponent)this.getModel()).get("lineHeight");
    }
}

