/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.widget.rialto.editpart;

import java.beans.PropertyChangeEvent;
import jp.sf.maskat.core.layout.Component;
import jp.sf.maskat.core.layout.DynaComponent;
import jp.sf.maskat.ui.editors.layout.commands.ChangePositionCommand;
import jp.sf.maskat.ui.editors.layout.editparts.ComponentEditPart;
import jp.sf.maskat.ui.editors.layout.editparts.LabelDirectEditable;
import jp.sf.maskat.widget.rialto.editpart.TabFolderEditPart;
import jp.sf.maskat.widget.rialto.figure.TabFigure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;

public class TabEditPart
extends ComponentEditPart
implements LabelDirectEditable {
    private int index;

    public TabEditPart(int index) {
        this.index = index;
    }

    protected IFigure createFigure() {
        return new TabFigure(this.getTitle());
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    protected void fireSelectionChanged() {
        ((TabFolderEditPart)this.getParent()).setActivePage(this);
        super.fireSelectionChanged();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("title".equals(evt.getPropertyName())) {
            ((TabFigure)this.getFigure()).setText(this.getTitle());
        }
        super.propertyChange(evt);
    }

    protected void refreshVisuals() {
        if (this.getParent() != null && this.getParent() instanceof TabFolderEditPart) {
            int width = ((TabFolderEditPart)this.getParent()).getWidthTabName();
            Rectangle constraint = new Rectangle(this.index * width, 0, width, 20);
            GraphicalEditPart editPart = (GraphicalEditPart)this.getParent();
            if (editPart instanceof GraphicalEditPart) {
                editPart.setLayoutConstraint((EditPart)this, this.getFigure(), (Object)constraint);
            }
        }
    }

    public Command createConstrainCommand(Object model, Rectangle constraint) {
        if (model instanceof Component) {
            return new ChangePositionCommand((Component)model);
        }
        return null;
    }

    public String getTitle() {
        return (String)((DynaComponent)this.getModel()).get("title");
    }

    public void setTitle(String text) {
        ((DynaComponent)this.getModel()).set("title", (Object)text);
    }

    public String getLabel() {
        return this.getTitle();
    }

    public void setLabel(String text) {
        this.setTitle(text);
    }
}

