/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.widget.rialto.editpart;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import jp.sf.maskat.core.MaskatElement;
import jp.sf.maskat.core.layout.Component;
import jp.sf.maskat.core.layout.DynaComponent;
import jp.sf.maskat.core.layout.DynaComponentClass;
import jp.sf.maskat.ui.editors.layout.editparts.ComponentEditPart;
import jp.sf.maskat.ui.editors.layout.editparts.HorizontalResizable;
import jp.sf.maskat.ui.editors.layout.editparts.VerticalResizable;
import jp.sf.maskat.widget.rialto.editpart.TabEditPart;
import jp.sf.maskat.widget.rialto.editpart.TabItemEditPart;
import jp.sf.maskat.widget.rialto.figure.TabFolderFigure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.swt.widgets.Display;

public class TabFolderEditPart
extends ComponentEditPart
implements HorizontalResizable,
VerticalResizable {
    protected IFigure createFigure() {
        return new TabFolderFigure();
    }

    protected List getModelChildren() {
        List result = null;
        if (this.getModel() instanceof MaskatElement) {
            result = ((MaskatElement)this.getModel()).getChildren();
        }
        return result != null ? result : super.getModelChildren();
    }

    protected void setActivePage(TabEditPart editPart) {
        TabFolderFigure figure = (TabFolderFigure)this.getFigure();
        figure.setAllTabPageInvisible();
        editPart.getFigure().setForegroundColor(Display.getCurrent().getSystemColor(2));
        TabItemEditPart item = this.getTabItemEditPart(editPart.getModel());
        if (item != null) {
            item.getFigure().setVisible(true);
        }
    }

    protected void fireActivated() {
        List children = this.getChildren();
        int i = 0;
        while (i < children.size()) {
            if (children.size() > 0 && children.get(i) instanceof TabEditPart) {
                this.setActivePage((TabEditPart)((Object)children.get(i)));
                return;
            }
            ++i;
        }
    }

    public void refreshSelectedWidget(ComponentEditPart child) {
        if (child instanceof TabEditPart) {
            this.setActivePage((TabEditPart)child);
        } else if (child instanceof TabItemEditPart) {
            this.setActivePage(this.getTabEditPart(child.getModel()));
        }
        if (this.getParent() instanceof ComponentEditPart) {
            ((ComponentEditPart)this.getParent()).refreshSelectedWidget((ComponentEditPart)this);
        }
        this.refreshVisuals();
    }

    protected void refreshChildren() {
        HashMap<Object, EditPart> modelToEditPart = new HashMap<Object, EditPart>();
        HashMap<Object, EditPart> tabEditPart = new HashMap<Object, EditPart>();
        List children = this.getChildren();
        int i = 0;
        while (i < children.size()) {
            EditPart editPart = (EditPart)children.get(i);
            if (!(editPart instanceof TabEditPart)) {
                modelToEditPart.put(editPart.getModel(), editPart);
            } else {
                tabEditPart.put(editPart.getModel(), editPart);
            }
            ++i;
        }
        List modelObjects = this.getModelChildren();
        int index = 0;
        int tabPosition = 0;
        int i2 = 0;
        while (i2 < modelObjects.size()) {
            Object model = modelObjects.get(i2);
            EditPart editPart = (EditPart)modelToEditPart.get(model);
            if (editPart != null) {
                this.reorderChild(editPart, index++);
                TabEditPart tabPart = (TabEditPart)((Object)tabEditPart.get(model));
                if (tabPart != null) {
                    tabPart.setIndex(tabPosition++);
                    this.reorderChild((EditPart)tabPart, index++);
                    tabPart.refreshVisuals();
                }
            } else {
                editPart = this.createChild(model);
                this.addChild(editPart, index++);
                if (editPart instanceof TabItemEditPart) {
                    TabEditPart part = new TabEditPart(tabPosition++);
                    part.setModel(model);
                    this.addChild((EditPart)part, index++);
                }
            }
            ++i2;
        }
        ArrayList list = new ArrayList();
        int i3 = index;
        while (i3 < children.size()) {
            list.add(children.get(i3));
            ++i3;
        }
        i3 = 0;
        while (i3 < list.size()) {
            this.removeChild((EditPart)list.get(i3));
            ++i3;
        }
    }

    protected void refreshVisuals() {
        Component comp = (Component)this.getModel();
        Rectangle constraint = new Rectangle(comp.getLeft(), comp.getTop(), comp.getWidth(), comp.getHeight());
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)constraint);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("addChild".equals(name) || "removeChild".equals(name)) {
            this.refreshChildren();
        } else if ("widthTabName".equals(name)) {
            List list = this.getChildren();
            int i = 0;
            while (i < list.size()) {
                Object obj = list.get(i);
                if (obj instanceof TabEditPart) {
                    ((TabEditPart)((Object)obj)).refreshVisuals();
                }
                ++i;
            }
        } else if ("constraint".equals(name) || "width".equals(name) || "height".equals(name)) {
            Component model = (Component)this.getModel();
            Rectangle constraint = new Rectangle(0, 21, model.getWidth() - 2, model.getHeight() - 20 - 1);
            List children = this.getChildren();
            int i = 0;
            while (i < children.size()) {
                Object child = children.get(i);
                if (child instanceof TabItemEditPart) {
                    TabItemEditPart editPart = (TabItemEditPart)((Object)child);
                    this.getFigure().setConstraint(editPart.getFigure(), (Object)constraint);
                }
                ++i;
            }
        }
        super.propertyChange(evt);
    }

    public boolean canAddChild(Object widget) {
        if (widget instanceof DynaComponent) {
            DynaComponentClass child = (DynaComponentClass)((DynaComponent)widget).getDynaClass();
            DynaComponentClass dynaClass = (DynaComponentClass)((DynaComponent)this.getModel()).getDynaClass();
            if (dynaClass.getLibrary() == child.getLibrary() && "tabItem".equals(child.getName())) {
                return true;
            }
        }
        return false;
    }

    public int getWidthTabName() {
        return (Integer)((DynaComponent)this.getModel()).get("widthTabName");
    }

    public void setWidthTabName(int width) {
        ((DynaComponent)this.getModel()).set("widthTabName", (Object)new Integer(width));
    }

    private TabItemEditPart getTabItemEditPart(Object model) {
        List children = this.getChildren();
        int i = 0;
        while (i < children.size()) {
            EditPart editPart = (EditPart)children.get(i);
            if (editPart instanceof TabItemEditPart && editPart.getModel() == model) {
                return (TabItemEditPart)editPart;
            }
            ++i;
        }
        return null;
    }

    private TabEditPart getTabEditPart(Object model) {
        List children = this.getChildren();
        int i = 0;
        while (i < children.size()) {
            EditPart editPart = (EditPart)children.get(i);
            if (editPart instanceof TabEditPart && editPart.getModel() == model) {
                return (TabEditPart)editPart;
            }
            ++i;
        }
        return null;
    }
}

