/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.widget.rialto.editpart;

import java.beans.PropertyChangeEvent;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import jp.sf.maskat.core.layout.DynaComponent;
import jp.sf.maskat.core.layout.DynaComponentClass;
import jp.sf.maskat.ui.editors.layout.editparts.ComponentEditPart;
import jp.sf.maskat.ui.editors.layout.editparts.LabelDirectEditable;
import jp.sf.maskat.ui.editors.layout.editpolicies.DataBindingEditPolicy;
import jp.sf.maskat.ui.editors.layout.editpolicies.LabelDirectEditPolicy;
import jp.sf.maskat.widget.rialto.editpart.TreeViewEditPart;
import jp.sf.maskat.widget.rialto.editpolicy.TreeNodeComponentEditPolicy;
import jp.sf.maskat.widget.rialto.editpolicy.TreeNodeXYLayoutEditPolicy;
import jp.sf.maskat.widget.rialto.figure.TreeViewFigure;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editpolicies.SnapFeedbackPolicy;
import org.eclipse.swt.graphics.Font;

public class TreeNodeEditPart
extends ComponentEditPart
implements LabelDirectEditable {
    public static Font DEFAULT_FONT = new Font(null, "Arial", 8, 0);
    private int layer;
    private int leftIterationIndex;
    static /* synthetic */ Class class$0;

    protected IFigure createFigure() {
        TreeViewFigure label = new TreeViewFigure(this.getLabel());
        label.setBorder((Border)new CompoundBorder((Border)new LineBorder(), (Border)new MarginBorder(2)));
        label.setOpaque(false);
        label.setFont(DEFAULT_FONT);
        XYLayout layout = new XYLayout();
        label.setLayoutManager((LayoutManager)layout);
        return label;
    }

    protected List getModelChildren() {
        return Collections.EMPTY_LIST;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new TreeNodeXYLayoutEditPolicy());
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new TreeNodeComponentEditPolicy());
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new LabelDirectEditPolicy());
        this.installEditPolicy("Snap Feedback", (EditPolicy)new SnapFeedbackPolicy());
        this.installEditPolicy("data binding", (EditPolicy)new DataBindingEditPolicy());
    }

    protected void refreshVisuals() {
        Dimension dim = this.figure.getPreferredSize();
        Rectangle constraint = new Rectangle(12 * this.getLayer(), 20 * this.getLeftIterationIndex(), dim.width, 20);
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)constraint);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("sText".equals(evt.getPropertyName())) {
            ((Label)this.getFigure()).setText((String)evt.getNewValue());
            this.getFigure().repaint();
            super.propertyChange(evt);
        }
        if ("addChild".equals(evt.getPropertyName()) || "removeChild".equals(evt.getPropertyName())) {
            this.refreshChildren();
            TreeViewEditPart editPart = this.getTreeViewEditPart((EditPart)this);
            editPart.refreshChildren();
            this.forceRefresh();
        }
    }

    private TreeViewEditPart getTreeViewEditPart(EditPart editPart) {
        EditPart parent = editPart.getParent();
        while (!(parent instanceof TreeViewEditPart) && !(parent instanceof RootEditPart)) {
            parent = parent.getParent();
        }
        if (!(parent instanceof TreeViewEditPart)) {
            return null;
        }
        return (TreeViewEditPart)parent;
    }

    public void forceRefresh() {
        this.refresh();
        Iterator it = this.getChildren().iterator();
        while (it.hasNext()) {
            ((EditPart)it.next()).refresh();
        }
    }

    public int travel(int nextIndex) {
        this.leftIterationIndex = nextIndex++;
        DynaComponent dynaComponent = (DynaComponent)this.getModel();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("jp.sf.maskat.core.layout.Component");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        List children = dynaComponent.getTypedChildren((Class)clazz);
        TreeViewEditPart treeView = this.getTreeViewEditPart((EditPart)this);
        int i = 0;
        while (i < children.size()) {
            TreeNodeEditPart child = treeView.getModelToEditPart(children.get(i));
            child.setLayer(this.layer + 1);
            nextIndex = child.travel(nextIndex);
            ++i;
        }
        return nextIndex;
    }

    public boolean canAddChild(Object widget) {
        if (widget instanceof DynaComponent) {
            DynaComponentClass child = (DynaComponentClass)((DynaComponent)widget).getDynaClass();
            DynaComponentClass dynaClass = (DynaComponentClass)((DynaComponent)this.getModel()).getDynaClass();
            if (dynaClass.getLibrary() == child.getLibrary() && "treeNode".equals(child.getName())) {
                return true;
            }
        }
        return false;
    }

    public String getLabel() {
        return (String)((DynaComponent)this.getModel()).get("sText");
    }

    public void setLabel(String text) {
        ((DynaComponent)this.getModel()).set("sText", (Object)text);
    }

    public int getLayer() {
        return this.layer;
    }

    public void setLayer(int layer) {
        this.layer = layer;
    }

    public int getLeftIterationIndex() {
        return this.leftIterationIndex;
    }

    public void setLeftIterationIndex(int leftIterationIndex) {
        this.leftIterationIndex = leftIterationIndex;
    }
}

