/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.widget.rialto.figure;

import java.util.List;
import jp.sf.maskat.core.layout.Component;
import jp.sf.maskat.widget.rialto.editpart.GridEditPart;
import jp.sf.maskat.widget.rialto.editpart.GridHeaderEditPart;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.swt.graphics.Font;

public class GridFigure
extends Label {
    public static Font DEFAULT_FONT = new Font(null, "Arial", 8, 0);
    public static int DEFAULT_WIDTH = 80;
    private GridEditPart grid;

    public GridFigure(GridEditPart grid) {
        this.grid = grid;
        this.setForegroundColor(ColorConstants.black);
        this.setFont(DEFAULT_FONT);
        this.setBorder((Border)new LineBorder());
        this.setLayoutManager((LayoutManager)new XYLayout());
    }

    protected void paintFigure(Graphics graphics) {
        List headers;
        super.paintFigure(graphics);
        graphics.translate(this.bounds.x, this.bounds.y);
        Component model = (Component)this.grid.getModel();
        if (model.getName() != null) {
            graphics.drawText(model.getName(), 0, 0);
        }
        if ((headers = this.grid.getHeadersIt()).size() > 0) {
            int currentX = 0;
            int i = 0;
            while (i < headers.size()) {
                Component header = (Component)((GridHeaderEditPart)((Object)headers.get(i))).getModel();
                graphics.drawLine(currentX += GridHeaderEditPart.toHeaderDisplayWidth(header.getWidth()), 21, currentX, model.getHeight());
                ++i;
            }
            int lineHeight = 0;
            try {
                lineHeight = this.grid.getLineHeight();
            }
            catch (NumberFormatException numberFormatException) {}
            lineHeight = Math.max(lineHeight, 5);
            int currentY = 41;
            int headerTotalWidth = this.grid.headerTotalWidth();
            while (currentY <= model.getHeight()) {
                graphics.drawLine(0, currentY, headerTotalWidth, currentY);
                currentY += lineHeight;
            }
        }
        graphics.translate(-this.bounds.x, -this.bounds.y);
    }
}

