/*
 * Decompiled with CFR 0.152.
 */
package javax.jdo;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;
import javax.jdo.JDOException;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.JDOFatalUserException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.spi.I18NHelper;
import javax.jdo.spi.PersistenceCapable;

public class JDOHelper {
    private static final I18NHelper msg = I18NHelper.getInstance("javax.jdo.Bundle");
    static /* synthetic */ Class class$java$util$Properties;

    public static PersistenceManager getPersistenceManager(Object object) {
        return object instanceof PersistenceCapable ? ((PersistenceCapable)object).jdoGetPersistenceManager() : null;
    }

    public static void makeDirty(Object object, String string) {
        if (object instanceof PersistenceCapable) {
            ((PersistenceCapable)object).jdoMakeDirty(string);
        }
    }

    public static Object getObjectId(Object object) {
        return object instanceof PersistenceCapable ? ((PersistenceCapable)object).jdoGetObjectId() : null;
    }

    public static Object getTransactionalObjectId(Object object) {
        return object instanceof PersistenceCapable ? ((PersistenceCapable)object).jdoGetObjectId() : null;
    }

    public static boolean isDirty(Object object) {
        return object instanceof PersistenceCapable ? ((PersistenceCapable)object).jdoIsDirty() : false;
    }

    public static boolean isTransactional(Object object) {
        return object instanceof PersistenceCapable ? ((PersistenceCapable)object).jdoIsTransactional() : false;
    }

    public static boolean isPersistent(Object object) {
        return object instanceof PersistenceCapable ? ((PersistenceCapable)object).jdoIsPersistent() : false;
    }

    public static boolean isNew(Object object) {
        return object instanceof PersistenceCapable ? ((PersistenceCapable)object).jdoIsNew() : false;
    }

    public static boolean isDeleted(Object object) {
        return object instanceof PersistenceCapable ? ((PersistenceCapable)object).jdoIsDeleted() : false;
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory(Properties properties) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return JDOHelper.getPersistenceManagerFactory(properties, classLoader);
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory(Properties properties, ClassLoader classLoader) {
        String string = (String)properties.get("javax.jdo.PersistenceManagerFactoryClass");
        if (string == null) {
            throw new JDOFatalUserException(msg.msg("EXC_NoClassNameProperty"));
        }
        try {
            Class<?> clazz = classLoader.loadClass(string);
            Method method = clazz.getMethod("getPersistenceManagerFactory", class$java$util$Properties == null ? (class$java$util$Properties = JDOHelper.class$("java.util.Properties")) : class$java$util$Properties);
            return (PersistenceManagerFactory)method.invoke(null, properties);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JDOFatalUserException(msg.msg("EXC_ClassNotFound", string), classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JDOFatalUserException(msg.msg("EXC_IllegalAccess", string), illegalAccessException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new JDOFatalInternalException(msg.msg("ERR_NoSuchMethod"), noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof JDOException) {
                throw (JDOException)throwable;
            }
            throw new JDOFatalUserException(msg.msg("EXC_getPersistenceManagerFactory"), invocationTargetException);
        }
        catch (Exception exception) {
            throw new JDOFatalInternalException(msg.msg("ERR_UnexpectedException"), exception);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

