/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import junit.framework.AssertionFailedError;
import org.easymock.ParameterMatcher;
import org.easymock.internal.MethodCall;
import org.easymock.internal.Parameters;
import org.easymock.internal.Range;
import org.easymock.internal.Result;
import org.easymock.internal.ResultList;

public class ResultListMap {
    private List parameterList = new ArrayList();
    private Map resultListMap = new HashMap();
    private ParameterMatcher matcher;
    private Method method;

    public ResultListMap(Method method, ParameterMatcher matcher) {
        this.method = method;
        this.matcher = matcher;
    }

    public void addExpected(Object[] params, Result returnValue, Range count) {
        Parameters parameters = new Parameters(params);
        if (!this.resultListMap.containsKey(parameters)) {
            this.resultListMap.put(parameters, new ResultList());
            this.parameterList.add(parameters);
        }
        ResultList list = (ResultList)this.resultListMap.get(parameters);
        list.add(returnValue, count);
    }

    public Result addActual(Object[] parameters) {
        ArrayList<Parameters> matches = new ArrayList<Parameters>();
        Iterator it = this.parameterList.iterator();
        while (it.hasNext()) {
            Parameters expected = (Parameters)it.next();
            if (!this.matcher.matches(expected.getParameters(), parameters)) continue;
            matches.add(expected);
            ResultList list = (ResultList)this.resultListMap.get(expected);
            Result result = list.next();
            if (result == null) continue;
            return result;
        }
        throw new AssertionFailedError(this.createFailureMessage(matches, parameters));
    }

    private String createFailureMessage(List matches, Object[] parameters) {
        Object lastMatch;
        String result = "";
        Object v0 = lastMatch = matches.isEmpty() ? null : matches.get(matches.size() - 1);
        if (matches.isEmpty()) {
            result = result + "\n    " + new MethodCall(this.method, parameters).toString(this.matcher) + ": " + new Range(2).expectedAndActual(1).replace('2', '0');
        }
        Iterator it = this.parameterList.iterator();
        while (it.hasNext()) {
            Parameters params = (Parameters)it.next();
            ResultList list = (ResultList)this.resultListMap.get(params);
            if (!matches.contains(params) && list.hasValidCallCount()) continue;
            int count = list.getCallCount();
            result = result + "\n    " + new MethodCall(this.method, params.getParameters()).toString(this.matcher) + ": ";
            result = result + list.getMessage(params == lastMatch ? count + 1 : count);
        }
        return result;
    }

    public void verify() {
        String failureMessage = "";
        boolean verifyFailed = false;
        Iterator it = this.parameterList.iterator();
        while (it.hasNext()) {
            Parameters expected = (Parameters)it.next();
            ResultList list = (ResultList)this.resultListMap.get(expected);
            if (list.hasValidCallCount()) continue;
            verifyFailed = true;
            failureMessage = failureMessage + "\n    " + new MethodCall(this.method, expected.getParameters()).toString(this.matcher) + ": " + list.getMessage();
        }
        if (verifyFailed) {
            throw new AssertionFailedError(failureMessage);
        }
    }
}

