/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template;

import freemarker.core.Environment;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public class TemplateException
extends Exception {
    private final Exception causeException;
    private final Environment env;
    private final String instructionStack;

    public TemplateException(Environment env) {
        this(null, null, env);
    }

    public TemplateException(String description, Environment env) {
        this(description, null, env);
    }

    public TemplateException(Exception cause, Environment env) {
        this(null, cause, env);
    }

    public TemplateException(String description, Exception cause, Environment env) {
        super(TemplateException.getDescription(description, cause));
        this.causeException = cause;
        this.env = env;
        if (env != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            env.outputInstructionStack(pw);
            pw.flush();
            this.instructionStack = sw.toString();
        } else {
            this.instructionStack = "";
        }
    }

    private static String getDescription(String description, Exception cause) {
        if (description != null) {
            return description;
        }
        if (cause != null) {
            return cause.getClass().getName() + ": " + cause.getMessage();
        }
        return "No error message";
    }

    public Exception getCauseException() {
        return this.causeException;
    }

    public Throwable getCause() {
        return this.causeException;
    }

    public String getFTLInstructionStack() {
        return this.instructionStack;
    }

    public Environment getEnvironment() {
        return this.env;
    }

    public void printStackTrace(PrintStream ps) {
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(ps), true);
        this.printStackTrace(pw);
        pw.flush();
    }

    public void printStackTrace(PrintWriter pw) {
        pw.println();
        pw.println(this.getMessage());
        pw.println("The problematic instruction:");
        pw.println(this.instructionStack);
        pw.println("Java backtrace for programmers:");
        pw.println("----------");
        super.printStackTrace(pw);
        if (this.causeException != null) {
            pw.println("Underlying cause: ");
            this.causeException.printStackTrace(pw);
        }
    }
}

