/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl;

import java.util.Date;
import java.util.List;
import java.util.Set;
import org.quartz.Calendar;
import org.quartz.JobDetail;
import org.quartz.JobListener;
import org.quartz.Scheduler;
import org.quartz.SchedulerContext;
import org.quartz.SchedulerException;
import org.quartz.SchedulerListener;
import org.quartz.SchedulerMetaData;
import org.quartz.Trigger;
import org.quartz.TriggerListener;
import org.quartz.core.QuartzScheduler;
import org.quartz.core.SchedulingContext;

public class StdScheduler
implements Scheduler {
    private QuartzScheduler sched;
    private SchedulingContext schedCtxt;

    public StdScheduler(QuartzScheduler sched, SchedulingContext schedCtxt) {
        this.sched = sched;
        this.schedCtxt = schedCtxt;
    }

    public String getSchedulerName() {
        return this.sched.getSchedulerName();
    }

    public String getSchedulerInstanceId() {
        return this.sched.getSchedulerInstanceId();
    }

    public SchedulerMetaData getMetaData() {
        return new SchedulerMetaData(this.getSchedulerName(), this.getSchedulerInstanceId(), this.getClass(), false, this.sched.runningSince() != null, this.isPaused(), this.isShutdown(), this.sched.runningSince(), this.sched.numJobsExecuted(), this.sched.getJobStoreClass(), this.sched.supportsPersistence(), this.sched.getThreadPoolClass(), this.sched.getThreadPoolSize(), this.sched.getVersion());
    }

    public SchedulerContext getContext() throws SchedulerException {
        return this.sched.getSchedulerContext();
    }

    public void start() throws SchedulerException {
        this.sched.start();
    }

    public void pause() {
        this.sched.pause();
    }

    public boolean isPaused() {
        return this.sched.isPaused();
    }

    public void shutdown() {
        this.sched.shutdown();
    }

    public void shutdown(boolean waitForJobsToComplete) {
        this.sched.shutdown(waitForJobsToComplete);
    }

    public boolean isShutdown() {
        return this.sched.isShutdown();
    }

    public List getCurrentlyExecutingJobs() {
        return this.sched.getCurrentlyExecutingJobs();
    }

    public Date scheduleJob(JobDetail jobDetail, Trigger trigger) throws SchedulerException {
        return this.sched.scheduleJob(this.schedCtxt, jobDetail, trigger);
    }

    public Date scheduleJob(Trigger trigger) throws SchedulerException {
        return this.sched.scheduleJob(this.schedCtxt, trigger);
    }

    public void addJob(JobDetail jobDetail, boolean replace) throws SchedulerException {
        this.sched.addJob(this.schedCtxt, jobDetail, replace);
    }

    public boolean deleteJob(String jobName, String groupName) throws SchedulerException {
        return this.sched.deleteJob(this.schedCtxt, jobName, groupName);
    }

    public boolean unscheduleJob(String triggerName, String groupName) throws SchedulerException {
        return this.sched.unscheduleJob(this.schedCtxt, triggerName, groupName);
    }

    public Date rescheduleJob(String triggerName, String groupName, Trigger newTrigger) throws SchedulerException {
        return this.sched.rescheduleJob(this.schedCtxt, triggerName, groupName, newTrigger);
    }

    public void triggerJob(String jobName, String groupName) throws SchedulerException {
        this.sched.triggerJob(this.schedCtxt, jobName, groupName);
    }

    public void triggerJobWithVolatileTrigger(String jobName, String groupName) throws SchedulerException {
        this.sched.triggerJobWithVolatileTrigger(this.schedCtxt, jobName, groupName);
    }

    public void pauseTrigger(String triggerName, String groupName) throws SchedulerException {
        this.sched.pauseTrigger(this.schedCtxt, triggerName, groupName);
    }

    public void pauseTriggerGroup(String groupName) throws SchedulerException {
        this.sched.pauseTriggerGroup(this.schedCtxt, groupName);
    }

    public void pauseJob(String jobName, String groupName) throws SchedulerException {
        this.sched.pauseJob(this.schedCtxt, jobName, groupName);
    }

    public void pauseJobGroup(String groupName) throws SchedulerException {
        this.sched.pauseJobGroup(this.schedCtxt, groupName);
    }

    public void resumeTrigger(String triggerName, String groupName) throws SchedulerException {
        this.sched.resumeTrigger(this.schedCtxt, triggerName, groupName);
    }

    public void resumeTriggerGroup(String groupName) throws SchedulerException {
        this.sched.resumeTriggerGroup(this.schedCtxt, groupName);
    }

    public void resumeJob(String jobName, String groupName) throws SchedulerException {
        this.sched.resumeJob(this.schedCtxt, jobName, groupName);
    }

    public void resumeJobGroup(String groupName) throws SchedulerException {
        this.sched.resumeJobGroup(this.schedCtxt, groupName);
    }

    public void pauseAll() throws SchedulerException {
        this.sched.pauseAll(this.schedCtxt);
    }

    public void resumeAll() throws SchedulerException {
        this.sched.resumeAll(this.schedCtxt);
    }

    public String[] getJobGroupNames() throws SchedulerException {
        return this.sched.getJobGroupNames(this.schedCtxt);
    }

    public Trigger[] getTriggersOfJob(String jobName, String groupName) throws SchedulerException {
        return this.sched.getTriggersOfJob(this.schedCtxt, jobName, groupName);
    }

    public String[] getJobNames(String groupName) throws SchedulerException {
        return this.sched.getJobNames(this.schedCtxt, groupName);
    }

    public String[] getTriggerGroupNames() throws SchedulerException {
        return this.sched.getTriggerGroupNames(this.schedCtxt);
    }

    public String[] getTriggerNames(String groupName) throws SchedulerException {
        return this.sched.getTriggerNames(this.schedCtxt, groupName);
    }

    public JobDetail getJobDetail(String jobName, String jobGroup) throws SchedulerException {
        return this.sched.getJobDetail(this.schedCtxt, jobName, jobGroup);
    }

    public Trigger getTrigger(String triggerName, String triggerGroup) throws SchedulerException {
        return this.sched.getTrigger(this.schedCtxt, triggerName, triggerGroup);
    }

    public int getTriggerState(String triggerName, String triggerGroup) throws SchedulerException {
        return this.sched.getTriggerState(this.schedCtxt, triggerName, triggerGroup);
    }

    public void addCalendar(String calName, Calendar calendar, boolean replace) throws SchedulerException {
        this.sched.addCalendar(this.schedCtxt, calName, calendar, replace);
    }

    public boolean deleteCalendar(String calName) throws SchedulerException {
        return this.sched.deleteCalendar(this.schedCtxt, calName);
    }

    public Calendar getCalendar(String calName) throws SchedulerException {
        return this.sched.getCalendar(this.schedCtxt, calName);
    }

    public String[] getCalendarNames() throws SchedulerException {
        return this.sched.getCalendarNames(this.schedCtxt);
    }

    public void addGlobalJobListener(JobListener jobListener) {
        this.sched.addGlobalJobListener(jobListener);
    }

    public void addJobListener(JobListener jobListener) {
        this.sched.addJobListener(jobListener);
    }

    public boolean removeGlobalJobListener(JobListener jobListener) {
        return this.sched.removeGlobalJobListener(jobListener);
    }

    public boolean removeJobListener(String name) {
        return this.sched.removeJobListener(name);
    }

    public List getGlobalJobListeners() {
        return this.sched.getGlobalJobListeners();
    }

    public Set getJobListenerNames() {
        return this.sched.getJobListenerNames();
    }

    public JobListener getJobListener(String name) {
        return this.sched.getJobListener(name);
    }

    public void addGlobalTriggerListener(TriggerListener triggerListener) {
        this.sched.addGlobalTriggerListener(triggerListener);
    }

    public void addTriggerListener(TriggerListener triggerListener) {
        this.sched.addTriggerListener(triggerListener);
    }

    public boolean removeGlobalTriggerListener(TriggerListener triggerListener) {
        return this.sched.removeGlobalTriggerListener(triggerListener);
    }

    public boolean removeTriggerListener(String name) {
        return this.sched.removeTriggerListener(name);
    }

    public List getGlobalTriggerListeners() {
        return this.sched.getGlobalTriggerListeners();
    }

    public Set getTriggerListenerNames() {
        return this.sched.getTriggerListenerNames();
    }

    public TriggerListener getTriggerListener(String name) {
        return this.sched.getTriggerListener(name);
    }

    public void addSchedulerListener(SchedulerListener schedulerListener) {
        this.sched.addSchedulerListener(schedulerListener);
    }

    public boolean removeSchedulerListener(SchedulerListener schedulerListener) {
        return this.sched.removeSchedulerListener(schedulerListener);
    }

    public List getSchedulerListeners() {
        return this.sched.getSchedulerListeners();
    }
}

