/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.datasource;

import com.ibatis.sqlmap.client.SqlMapException;
import com.ibatis.sqlmap.engine.datasource.DataSourceFactory;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class JndiDataSourceFactory
implements DataSourceFactory {
    private DataSource dataSource;

    public void initialize(Map properties) {
        try {
            InitialContext initCtx = new InitialContext();
            if (properties.containsKey("DBJndiContext")) {
                this.dataSource = (DataSource)initCtx.lookup((String)properties.get("DBJndiContext"));
            } else if (properties.containsKey("DBFullJndiContext")) {
                this.dataSource = (DataSource)initCtx.lookup((String)properties.get("DBFullJndiContext"));
            } else {
                Context ctx = (Context)initCtx.lookup((String)properties.get("DBInitialContext"));
                this.dataSource = (DataSource)ctx.lookup((String)properties.get("DBLookup"));
            }
        }
        catch (NamingException e) {
            throw new SqlMapException("There was an error configuring JndiDataSourceDaoTransactionPool. Cause: " + e, e);
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public String[] getExpectedProperties() {
        return new String[]{"DBFullJndiContext"};
    }
}

