/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.cache;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.engine.QueryParameters;
import net.sf.hibernate.engine.RowSelection;
import net.sf.hibernate.engine.TypedValue;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.util.EqualsHelper;

public class QueryKey
implements Serializable {
    private final String sqlQueryString;
    private final Type[] types;
    private final Object[] values;
    private final Integer firstRow;
    private final Integer maxRows;
    private final Map namedParameters;

    public QueryKey(String queryString, QueryParameters queryParameters) {
        this.sqlQueryString = queryString;
        this.types = queryParameters.getPositionalParameterTypes();
        this.values = queryParameters.getPositionalParameterValues();
        RowSelection selection = queryParameters.getRowSelection();
        if (selection != null) {
            this.firstRow = selection.getFirstRow();
            this.maxRows = selection.getMaxRows();
        } else {
            this.firstRow = null;
            this.maxRows = null;
        }
        this.namedParameters = queryParameters.getNamedParameters();
    }

    public boolean equals(Object other) {
        QueryKey that = (QueryKey)other;
        if (!this.sqlQueryString.equals(that.sqlQueryString)) {
            return false;
        }
        if (!EqualsHelper.equals(this.firstRow, that.firstRow) || !EqualsHelper.equals(this.maxRows, that.maxRows)) {
            return false;
        }
        if (this.types == null) {
            if (that.types != null) {
                return false;
            }
        } else {
            if (that.types == null) {
                return false;
            }
            if (this.types.length != that.types.length) {
                return false;
            }
            for (int i = 0; i < this.types.length; ++i) {
                if (!this.types[i].equals(that.types[i])) {
                    return false;
                }
                try {
                    if (this.types[i].equals(this.values[i], that.values[i])) continue;
                    return false;
                }
                catch (HibernateException he) {
                    return false;
                }
            }
        }
        if (this.namedParameters == null) {
            if (that.namedParameters != null) {
                return false;
            }
        } else {
            if (that.namedParameters == null) {
                return false;
            }
            if (this.namedParameters.size() != that.namedParameters.size()) {
                return false;
            }
            Iterator iter = this.namedParameters.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry me = iter.next();
                TypedValue thisTv = (TypedValue)me.getValue();
                TypedValue thatTv = (TypedValue)that.namedParameters.get(me.getKey());
                if (thatTv == null) {
                    return false;
                }
                if (!thatTv.getType().equals(thisTv.getType())) {
                    return false;
                }
                try {
                    if (thisTv.getType().equals(thisTv.getValue(), thatTv.getValue())) continue;
                    return false;
                }
                catch (HibernateException he) {
                    return false;
                }
            }
        }
        return true;
    }

    public int hashCode() {
        return this.sqlQueryString.hashCode();
    }
}

