/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.dialect;

import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.util.StringHelper;

public class MySQLDialect
extends Dialect {
    public MySQLDialect() {
        this.registerColumnType(-7, "BIT");
        this.registerColumnType(-5, "BIGINT");
        this.registerColumnType(5, "SMALLINT");
        this.registerColumnType(-6, "TINYINT");
        this.registerColumnType(4, "INTEGER");
        this.registerColumnType(1, "CHAR(1)");
        this.registerColumnType(12, "LONGTEXT");
        this.registerColumnType(12, 0xFFFFFF, "MEDIUMTEXT");
        this.registerColumnType(12, 65535, "TEXT");
        this.registerColumnType(12, 255, "VARCHAR($l)");
        this.registerColumnType(6, "FLOAT");
        this.registerColumnType(8, "DOUBLE PRECISION");
        this.registerColumnType(91, "DATE");
        this.registerColumnType(92, "TIME");
        this.registerColumnType(93, "DATETIME");
        this.registerColumnType(-3, "LONGBLOB");
        this.registerColumnType(-3, 0xFFFFFF, "MEDIUMBLOB");
        this.registerColumnType(-3, 65535, "BLOB");
        this.registerColumnType(-3, 255, "VARCHAR($l) BINARY");
        this.registerColumnType(2, "NUMERIC(19, $l)");
        this.registerColumnType(2004, "LONGBLOB");
        this.registerColumnType(2004, 0xFFFFFF, "MEDIUMBLOB");
        this.registerColumnType(2004, 65535, "BLOB");
        this.registerColumnType(2005, "LONGTEXT");
        this.registerColumnType(2005, 0xFFFFFF, "MEDIUMTEXT");
        this.registerColumnType(2005, 65535, "TEXT");
        this.getDefaultProperties().setProperty("hibernate.use_outer_join", "true");
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "15");
    }

    public String getAddColumnString() {
        return "add column";
    }

    public boolean dropConstraints() {
        return false;
    }

    public boolean qualifyIndexName() {
        return false;
    }

    public boolean supportsIdentityColumns() {
        return true;
    }

    public String getIdentitySelectString() {
        return "SELECT LAST_INSERT_ID()";
    }

    public String getIdentityColumnString() {
        return "NOT NULL AUTO_INCREMENT";
    }

    public String getAddForeignKeyConstraintString(String constraintName, String[] foreignKey, String referencedTable, String[] primaryKey) {
        String cols = StringHelper.join(", ", foreignKey);
        return new StringBuffer(30).append(" add index (").append(cols).append("), add constraint ").append(constraintName).append(" foreign key (").append(cols).append(") references ").append(referencedTable).append(" (").append(StringHelper.join(", ", primaryKey)).append(')').toString();
    }

    public boolean supportsLimit() {
        return true;
    }

    public String getLimitString(String sql, boolean hasOffset) {
        return new StringBuffer(sql.length() + 20).append(sql).append(hasOffset ? " limit ?, ?" : " limit ?").toString();
    }

    public char closeQuote() {
        return '`';
    }

    public char openQuote() {
        return '`';
    }

    public boolean supportsIfExistsBeforeTableName() {
        return true;
    }

    public char getSchemaSeperator() {
        return '_';
    }
}

