/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.impl;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import net.sf.hibernate.Hibernate;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.JDBCException;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.ScrollableResults;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.type.Type;

public class ScrollableResultsImpl
implements ScrollableResults {
    private final ResultSet rs;
    private final PreparedStatement ps;
    private final SessionImplementor sess;
    private final Type[] types;
    private final String[][] names;

    public boolean scroll(int i) throws HibernateException {
        try {
            return this.rs.relative(i);
        }
        catch (SQLException sqle) {
            throw new JDBCException(sqle);
        }
    }

    public boolean first() throws HibernateException {
        try {
            return this.rs.first();
        }
        catch (SQLException sqle) {
            throw new JDBCException(sqle);
        }
    }

    public boolean last() throws HibernateException {
        try {
            return this.rs.last();
        }
        catch (SQLException sqle) {
            throw new JDBCException(sqle);
        }
    }

    public boolean next() throws HibernateException {
        try {
            return this.rs.next();
        }
        catch (SQLException sqle) {
            throw new JDBCException(sqle);
        }
    }

    public boolean previous() throws HibernateException {
        try {
            return this.rs.previous();
        }
        catch (SQLException sqle) {
            throw new JDBCException(sqle);
        }
    }

    public Object[] get() throws HibernateException {
        Object[] row = new Object[this.types.length];
        for (int i = 0; i < this.types.length; ++i) {
            try {
                row[i] = this.types[i].nullSafeGet(this.rs, this.names[i], this.sess, null);
                continue;
            }
            catch (SQLException sqle) {
                throw new JDBCException(sqle);
            }
        }
        return row;
    }

    public Object get(int col) throws HibernateException {
        try {
            return this.types[col].nullSafeGet(this.rs, this.names[col], this.sess, null);
        }
        catch (SQLException sqle) {
            throw new JDBCException(sqle);
        }
    }

    private Object getFinal(int col, Type returnType) throws HibernateException {
        if (returnType.getReturnedClass() == this.types[col].getReturnedClass()) {
            return this.get(col);
        }
        return this.get(col, returnType);
    }

    private Object getNonFinal(int col, Type returnType) throws HibernateException {
        if (returnType.getReturnedClass().isAssignableFrom(this.types[col].getReturnedClass())) {
            return this.get(col);
        }
        return this.get(col, returnType);
    }

    public ScrollableResultsImpl(ResultSet rs, PreparedStatement ps, SessionImplementor sess, Type[] types, String[][] columnNames) throws MappingException {
        this.rs = rs;
        this.ps = ps;
        this.sess = sess;
        this.types = types;
        this.names = columnNames;
    }

    public BigDecimal getBigDecimal(int col) throws HibernateException {
        return (BigDecimal)this.getFinal(col, Hibernate.BIG_DECIMAL);
    }

    public byte[] getBinary(int col) throws HibernateException {
        return (byte[])this.getFinal(col, Hibernate.BINARY);
    }

    public String getText(int col) throws HibernateException {
        return (String)this.getFinal(col, Hibernate.TEXT);
    }

    public Blob getBlob(int col) throws HibernateException {
        return (Blob)this.getNonFinal(col, Hibernate.BLOB);
    }

    public Clob getClob(int col) throws HibernateException {
        return (Clob)this.getNonFinal(col, Hibernate.CLOB);
    }

    public Boolean getBoolean(int col) throws HibernateException {
        return (Boolean)this.getFinal(col, Hibernate.BOOLEAN);
    }

    public Byte getByte(int col) throws HibernateException {
        return (Byte)this.getFinal(col, Hibernate.BYTE);
    }

    public Character getCharacter(int col) throws HibernateException {
        return (Character)this.getFinal(col, Hibernate.CHARACTER);
    }

    public Date getDate(int col) throws HibernateException {
        return (Date)this.getNonFinal(col, Hibernate.TIMESTAMP);
    }

    public Calendar getCalendar(int col) throws HibernateException {
        return (Calendar)this.getNonFinal(col, Hibernate.CALENDAR);
    }

    public Double getDouble(int col) throws HibernateException {
        return (Double)this.getFinal(col, Hibernate.DOUBLE);
    }

    public Float getFloat(int col) throws HibernateException {
        return (Float)this.getFinal(col, Hibernate.FLOAT);
    }

    public Integer getInteger(int col) throws HibernateException {
        return (Integer)this.getFinal(col, Hibernate.INTEGER);
    }

    public Long getLong(int col) throws HibernateException {
        return (Long)this.getFinal(col, Hibernate.LONG);
    }

    public Short getShort(int col) throws HibernateException {
        return (Short)this.getFinal(col, Hibernate.SHORT);
    }

    public String getString(int col) throws HibernateException {
        return (String)this.getFinal(col, Hibernate.STRING);
    }

    public void afterLast() throws HibernateException {
        try {
            this.rs.afterLast();
        }
        catch (SQLException sqle) {
            throw new JDBCException(sqle);
        }
    }

    public void beforeFirst() throws HibernateException {
        try {
            this.rs.beforeFirst();
        }
        catch (SQLException sqle) {
            throw new JDBCException(sqle);
        }
    }

    public void close() throws HibernateException {
        try {
            this.sess.getBatcher().closeQueryStatement(this.ps, this.rs);
        }
        catch (SQLException sqle) {
            throw new JDBCException(sqle);
        }
    }

    public Locale getLocale(int col) throws HibernateException {
        return (Locale)this.getFinal(col, Hibernate.LOCALE);
    }

    public TimeZone getTimeZone(int col) throws HibernateException {
        return (TimeZone)this.getNonFinal(col, Hibernate.TIMEZONE);
    }

    public Type getType(int i) {
        return this.types[i];
    }

    public boolean isFirst() throws HibernateException {
        try {
            return this.rs.isFirst();
        }
        catch (SQLException sqle) {
            throw new JDBCException(sqle);
        }
    }

    public boolean isLast() throws HibernateException {
        try {
            return this.rs.isLast();
        }
        catch (SQLException sqle) {
            throw new JDBCException(sqle);
        }
    }

    public Object get(int i, Type type) throws HibernateException {
        try {
            return type.nullSafeGet(this.rs, this.names[i], this.sess, null);
        }
        catch (SQLException sqle) {
            throw new JDBCException(sqle);
        }
    }

    public int getRowNumber() throws HibernateException {
        try {
            return this.rs.getRow() - 1;
        }
        catch (SQLException sqle) {
            throw new JDBCException(sqle);
        }
    }

    public boolean setRowNumber(int rowNumber) throws HibernateException {
        if (rowNumber >= 0) {
            ++rowNumber;
        }
        try {
            return this.rs.absolute(rowNumber);
        }
        catch (SQLException sqle) {
            throw new JDBCException(sqle);
        }
    }
}

