/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.attributes;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.attributes.AttributeRepositoryClass;
import org.apache.commons.attributes.CachedRepository;
import org.apache.commons.attributes.CircularDependencyError;
import org.apache.commons.attributes.DefaultCachedRepository;
import org.apache.commons.attributes.MultipleAttributesError;
import org.apache.commons.attributes.RepositoryError;
import org.apache.commons.attributes.RuntimeAttributeRepository;

public class Attributes {
    private static final Map classRepositories = new WeakHashMap();
    private static List initList = new ArrayList();

    private static synchronized CachedRepository getCachedRepository(Class clazz) throws RepositoryError, CircularDependencyError {
        CachedRepository cached;
        if (classRepositories.containsKey(clazz)) {
            CachedRepository cr = (CachedRepository)classRepositories.get(clazz);
            if (cr == null) {
                ArrayList dependencyList = new ArrayList();
                dependencyList.addAll(initList);
                throw new CircularDependencyError(clazz.getName(), dependencyList);
            }
            return cr;
        }
        initList.add(clazz.getName());
        classRepositories.put(clazz, null);
        try {
            Class<?> attributeRepo = Class.forName(clazz.getName() + "$__attributeRepository", true, clazz.getClassLoader());
            AttributeRepositoryClass repo = (AttributeRepositoryClass)attributeRepo.newInstance();
            cached = new DefaultCachedRepository(clazz, repo);
        }
        catch (ClassNotFoundException cnfe) {
            cached = CachedRepository.EMPTY;
        }
        catch (InstantiationException ie) {
            throw new RepositoryError(ie);
        }
        catch (IllegalAccessException iae) {
            throw new RepositoryError(iae);
        }
        classRepositories.put(clazz, cached);
        initList.remove(initList.size() - 1);
        return cached;
    }

    private static Object getAttribute(Collection attrs, Class attributeClass) throws MultipleAttributesError {
        Object candidate = null;
        Iterator iter = attrs.iterator();
        while (iter.hasNext()) {
            Object attr = iter.next();
            if (attr.getClass() != attributeClass) continue;
            if (candidate == null) {
                candidate = attr;
                continue;
            }
            throw new MultipleAttributesError(attributeClass.getName());
        }
        return candidate;
    }

    public static Object getAttribute(Class clazz, Class attributeClass) throws MultipleAttributesError {
        return Attributes.getAttribute(Attributes.getAttributes(clazz), attributeClass);
    }

    public static Object getAttribute(Field field, Class attributeClass) throws MultipleAttributesError {
        return Attributes.getAttribute(Attributes.getAttributes(field), attributeClass);
    }

    public static Object getAttribute(Constructor ctor, Class attributeClass) throws MultipleAttributesError {
        return Attributes.getAttribute(Attributes.getAttributes(ctor), attributeClass);
    }

    public static Object getAttribute(Method method, Class attributeClass) throws MultipleAttributesError {
        return Attributes.getAttribute(Attributes.getAttributes(method), attributeClass);
    }

    public static Object getParameterAttribute(Method method, int parameter, Class attributeClass) throws MultipleAttributesError {
        return Attributes.getAttribute(Attributes.getParameterAttributes(method, parameter), attributeClass);
    }

    public static Object getParameterAttribute(Constructor constructor, int parameter, Class attributeClass) throws MultipleAttributesError {
        return Attributes.getAttribute(Attributes.getParameterAttributes(constructor, parameter), attributeClass);
    }

    public static Object getReturnAttribute(Method method, Class attributeClass) throws MultipleAttributesError {
        return Attributes.getAttribute(Attributes.getReturnAttributes(method), attributeClass);
    }

    public static Collection getAttributes(Class clazz) {
        return Attributes.getCachedRepository(clazz).getAttributes();
    }

    public static Collection getAttributes(Method method) {
        return Attributes.getCachedRepository(method.getDeclaringClass()).getAttributes(method);
    }

    public static Collection getParameterAttributes(Method method, int parameter) {
        return Attributes.getCachedRepository(method.getDeclaringClass()).getParameterAttributes(method, parameter);
    }

    public static Collection getParameterAttributes(Constructor constructor, int parameter) {
        return Attributes.getCachedRepository(constructor.getDeclaringClass()).getParameterAttributes(constructor, parameter);
    }

    public static Collection getReturnAttributes(Method method) {
        return Attributes.getCachedRepository(method.getDeclaringClass()).getReturnAttributes(method);
    }

    public static Collection getAttributes(Field field) {
        return Attributes.getCachedRepository(field.getDeclaringClass()).getAttributes(field);
    }

    public static Collection getAttributes(Constructor cons) {
        return Attributes.getCachedRepository(cons.getDeclaringClass()).getAttributes(cons);
    }

    private static Collection getAttributes(Collection attrs, Class attributeClass) {
        HashSet result = new HashSet();
        Iterator iter = attrs.iterator();
        while (iter.hasNext()) {
            Object attr = iter.next();
            if (attr.getClass() != attributeClass) continue;
            result.add(attr);
        }
        return Collections.unmodifiableCollection(result);
    }

    public static Collection getAttributes(Class clazz, Class attributeClass) {
        return Attributes.getAttributes(Attributes.getAttributes(clazz), attributeClass);
    }

    public static Collection getAttributes(Field field, Class attributeClass) {
        return Attributes.getAttributes(Attributes.getAttributes(field), attributeClass);
    }

    public static Collection getAttributes(Constructor ctor, Class attributeClass) {
        return Attributes.getAttributes(Attributes.getAttributes(ctor), attributeClass);
    }

    public static Collection getAttributes(Method method, Class attributeClass) {
        return Attributes.getAttributes(Attributes.getAttributes(method), attributeClass);
    }

    public static Collection getParameterAttributes(Method method, int parameter, Class attributeClass) {
        return Attributes.getAttributes(Attributes.getParameterAttributes(method, parameter), attributeClass);
    }

    public static Collection getParameterAttributes(Constructor constructor, int parameter, Class attributeClass) {
        return Attributes.getAttributes(Attributes.getParameterAttributes(constructor, parameter), attributeClass);
    }

    public static Collection getReturnAttributes(Method method, Class attributeClass) {
        return Attributes.getAttributes(Attributes.getReturnAttributes(method), attributeClass);
    }

    private static boolean hasAttributeType(Collection attrs, Class attributeClass) {
        Iterator iter = attrs.iterator();
        while (iter.hasNext()) {
            Object attr = iter.next();
            if (attr.getClass() != attributeClass) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAttributeType(Class clazz, Class attributeClass) {
        return Attributes.hasAttributeType(Attributes.getAttributes(clazz), attributeClass);
    }

    public static boolean hasAttributeType(Field field, Class attributeClass) {
        return Attributes.hasAttributeType(Attributes.getAttributes(field), attributeClass);
    }

    public static boolean hasAttributeType(Constructor ctor, Class attributeClass) {
        return Attributes.hasAttributeType(Attributes.getAttributes(ctor), attributeClass);
    }

    public static boolean hasAttributeType(Method method, Class attributeClass) {
        return Attributes.hasAttributeType(Attributes.getAttributes(method), attributeClass);
    }

    public static boolean hasParameterAttributeType(Method method, int parameter, Class attributeClass) {
        return Attributes.hasAttributeType(Attributes.getParameterAttributes(method, parameter), attributeClass);
    }

    public static boolean hasParameterAttributeType(Constructor constructor, int parameter, Class attributeClass) {
        return Attributes.hasAttributeType(Attributes.getParameterAttributes(constructor, parameter), attributeClass);
    }

    public static boolean hasReturnAttributeType(Method method, Class attributeClass) {
        return Attributes.hasAttributeType(Attributes.getReturnAttributes(method), attributeClass);
    }

    private static boolean hasAttribute(Collection attrs, Object attribute) {
        return attrs.contains(attribute);
    }

    public static boolean hasAttribute(Class clazz, Object attribute) {
        return Attributes.hasAttribute(Attributes.getAttributes(clazz), attribute);
    }

    public static boolean hasAttribute(Field field, Object attribute) {
        return Attributes.hasAttribute(Attributes.getAttributes(field), attribute);
    }

    public static boolean hasAttribute(Constructor ctor, Object attribute) {
        return Attributes.hasAttribute(Attributes.getAttributes(ctor), attribute);
    }

    public static boolean hasAttribute(Method method, Object attribute) {
        return Attributes.hasAttribute(Attributes.getAttributes(method), attribute);
    }

    public static boolean hasParameterAttribute(Method method, int parameter, Object attribute) {
        return Attributes.hasAttribute(Attributes.getParameterAttributes(method, parameter), attribute);
    }

    public static boolean hasParameterAttribute(Constructor constructor, int parameter, Object attribute) {
        return Attributes.hasAttribute(Attributes.getParameterAttributes(constructor, parameter), attribute);
    }

    public static boolean hasReturnAttribute(Method method, Object attribute) {
        return Attributes.hasAttribute(Attributes.getReturnAttributes(method), attribute);
    }

    public static synchronized void setAttributes(RuntimeAttributeRepository repo) throws IllegalStateException {
        repo.seal();
        Class clazz = repo.getDefinedClass();
        if (classRepositories.get(clazz) != null) {
            throw new IllegalStateException(clazz.getName());
        }
        DefaultCachedRepository cached = new DefaultCachedRepository(clazz, repo);
        classRepositories.put(clazz, cached);
    }
}

