/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.db.jta;

import com.ibatis.db.jta.JtaTransactionException;
import javax.transaction.UserTransaction;

public class JtaTransaction {
    private UserTransaction userTransaction;
    private boolean newTransaction;
    private boolean started;

    public JtaTransaction(UserTransaction userTransaction) {
        this.userTransaction = userTransaction;
    }

    public void begin() throws JtaTransactionException {
        try {
            boolean bl = this.newTransaction = this.userTransaction.getStatus() == 6;
            if (this.newTransaction) {
                this.userTransaction.begin();
            }
        }
        catch (Exception exception) {
            throw new JtaTransactionException("Could not start transaction.  Cause: ", exception);
        }
        this.started = true;
    }

    public void commit() throws JtaTransactionException {
        if (!this.started) {
            throw new JtaTransactionException("Could not commit.  A transaction has not started.  Call begin() first.");
        }
        try {
            if (this.newTransaction) {
                this.userTransaction.commit();
            }
        }
        catch (Exception exception) {
            throw new JtaTransactionException("Could not commit.  Cause: ", exception);
        }
    }

    public void rollback() throws JtaTransactionException {
        if (!this.started) {
            throw new JtaTransactionException("Could not rollback.  A transaction has not started.  Call begin() first.");
        }
        try {
            if (this.newTransaction) {
                this.userTransaction.rollback();
            } else {
                this.userTransaction.setRollbackOnly();
            }
        }
        catch (Exception exception) {
            throw new JtaTransactionException("Could not rollback.  Cause: ", exception);
        }
    }
}

