/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.db.sqlmap.datasource;

import com.ibatis.db.sqlmap.SqlMapException;
import com.ibatis.db.sqlmap.datasource.DataSourceFactory;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class JndiDataSourceFactory
implements DataSourceFactory {
    private DataSource dataSource;

    public void initialize(Map map) {
        try {
            InitialContext initialContext = new InitialContext();
            if (map.containsKey("DBFullJndiContext")) {
                this.dataSource = (DataSource)initialContext.lookup((String)map.get("DBFullJndiContext"));
            } else {
                Context context = (Context)initialContext.lookup((String)map.get("DBInitialContext"));
                this.dataSource = (DataSource)context.lookup((String)map.get("DBLookup"));
            }
        }
        catch (NamingException namingException) {
            throw new SqlMapException("There was an error configuring JndiDataSourceDaoTransactionPool. Cause: " + namingException, namingException);
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public String[] getExpectedProperties() {
        return new String[]{"DBFullJndiContext"};
    }
}

