/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.db.sqlmap.typehandler;

import com.ibatis.db.sqlmap.ParameterMapping;
import com.ibatis.db.sqlmap.ResultMapping;
import com.ibatis.db.sqlmap.typehandler.BaseTypeHandler;
import com.ibatis.db.sqlmap.value.BooleanValue;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class BooleanTypeHandler
extends BaseTypeHandler {
    protected Object getValueByName(ResultMapping resultMapping, ResultSet resultSet) throws SQLException {
        return resultSet.getBoolean(resultMapping.getColumnName()) ? Boolean.TRUE : Boolean.FALSE;
    }

    protected Object getValueByIndex(ResultMapping resultMapping, ResultSet resultSet) throws SQLException {
        return resultSet.getBoolean(resultMapping.getColumnIndex()) ? Boolean.TRUE : Boolean.FALSE;
    }

    protected Object getNullValue(String string) throws SQLException {
        return Boolean.valueOf(string);
    }

    public Object instantiateValue() {
        return new BooleanValue();
    }

    public boolean isEqualToNullValue(String string, Object object) {
        return Boolean.valueOf(string).equals(object);
    }

    public boolean isSimpleType() {
        return true;
    }

    public void setParameter(ParameterMapping parameterMapping, PreparedStatement preparedStatement, int n, Object object) throws SQLException {
        preparedStatement.setBoolean(n, (Boolean)object);
    }
}

